/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.image.AsyncBufferedFile;
import org.lsst.ccs.utilities.image.direct.DirectByteBufferCache;

public class AsyncBufferedFileTest {
    @Test
    public void testWriteAsync() throws IOException {
        Path tempFile = Files.createTempFile("test", "fits", new FileAttribute[0]);
        int maxSize = 100000;
        int actualSize = 0;
        int[] badData = new int[100];
        try (AsynchronousFileChannel afc = AsynchronousFileChannel.open(tempFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             AsyncBufferedFile abf = new AsyncBufferedFile(afc);){
            Random random = new Random(12345L);
            for (int n = 0; n < 10000; ++n) {
                int position = n == 0 ? 0 : random.nextInt(maxSize);
                int size = 1 + random.nextInt(999);
                size = Math.min(size, maxSize - position);
                int[] data = new int[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = position + i;
                }
                abf.seek((long)(4 * position));
                if (n == 500) {
                    System.out.println("Writing bad data");
                    abf.write(badData, 0, Math.min(badData.length, data.length));
                }
                abf.write(data);
                actualSize = Math.max(actualSize, position + size);
            }
        }
        this.checkFile(actualSize, tempFile);
    }

    private void checkFile(int actualSize, Path tempFile) throws IOException {
        Assert.assertEquals((long)(4 * actualSize), (long)Files.size(tempFile));
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(tempFile, StandardOpenOption.DELETE_ON_CLOSE)));){
            for (int i = 0; i < actualSize; ++i) {
                int data = in.readInt();
                Assert.assertEquals((String)("Data incorrect at " + i), (long)i, (long)data);
            }
        }
        System.out.println(DirectByteBufferCache.instance().toString());
        Assert.assertEquals((long)0L, (long)DirectByteBufferCache.instance().getInUseCount());
    }

    @Test
    public void testOpenCloseAsync() throws IOException {
        Path tempFile = Files.createTempFile("test", "fits", new FileAttribute[0]);
        try (AsynchronousFileChannel afc = AsynchronousFileChannel.open(tempFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             AsyncBufferedFile abf = new AsyncBufferedFile(afc);){
            abf.seek(1000L);
        }
        Assert.assertEquals((long)0L, (long)DirectByteBufferCache.instance().getInUseCount());
        System.out.println(DirectByteBufferCache.instance().toString());
    }

    @Test
    public void testWriteSequential() throws IOException {
        Path tempFile = Files.createTempFile("test", "fits", new FileAttribute[0]);
        int[] data = new int[1000];
        try (AsynchronousFileChannel afc = AsynchronousFileChannel.open(tempFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             AsyncBufferedFile abf = new AsyncBufferedFile(afc);){
            for (int i = 0; i < 100000; i += data.length) {
                for (int j = 0; j < data.length; ++j) {
                    data[j] = i + j;
                }
                abf.write(data);
            }
        }
        this.checkFile(100000, tempFile);
    }

    @Test
    public void testHandleExceptions() throws IOException {
        Path tempFile = Files.createTempFile("test", "fits", new FileAttribute[0]);
        int[] data = new int[1000];
        Random random = new Random(67890L);
        try {
            AsynchronousFileChannel afc = AsynchronousFileChannel.open(tempFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            BuggyAsynchronousFileChannel bafc = new BuggyAsynchronousFileChannel(afc, random, 0.75);
            try (AsyncBufferedFile abf = new AsyncBufferedFile((AsynchronousFileChannel)bafc);){
                for (int i = 0; i < 100000; i += data.length) {
                    for (int j = 0; j < data.length; ++j) {
                        data[j] = i + j;
                    }
                    abf.write(data);
                }
            }
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IOException x) {
            System.out.println(x);
        }
        Assert.assertEquals((long)0L, (long)DirectByteBufferCache.instance().getInUseCount());
    }

    private static class BuggyAsynchronousFileChannel
    extends AsynchronousFileChannel {
        private final AsynchronousFileChannel wrapped;
        private final Random random;
        private final double errorProbability;

        public BuggyAsynchronousFileChannel(AsynchronousFileChannel wrapped, Random random, double errorProbability) {
            this.wrapped = wrapped;
            this.random = random;
            this.errorProbability = errorProbability;
        }

        @Override
        public long size() throws IOException {
            return this.wrapped.size();
        }

        @Override
        public AsynchronousFileChannel truncate(long size) throws IOException {
            return this.wrapped.truncate(size);
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.wrapped.force(metaData);
        }

        @Override
        public <A> void lock(long position, long size, boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
            this.wrapped.lock(position, size, shared, attachment, handler);
        }

        @Override
        public Future<FileLock> lock(long position, long size, boolean shared) {
            return this.wrapped.lock(position, size, shared);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.wrapped.tryLock(position, size, shared);
        }

        @Override
        public <A> void read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
            this.wrapped.read(dst, position, attachment, handler);
        }

        @Override
        public Future<Integer> read(ByteBuffer dst, long position) {
            return this.wrapped.read(dst, position);
        }

        @Override
        public <A> void write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
            double nextDouble = this.random.nextDouble();
            System.out.println("Random failure " + nextDouble);
            if (nextDouble < this.errorProbability) {
                handler.failed(new IOException("Random failure"), attachment);
            } else {
                this.wrapped.write(src, position, attachment, handler);
            }
        }

        @Override
        public Future<Integer> write(ByteBuffer src, long position) {
            return this.wrapped.write(src, position);
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public boolean isOpen() {
            return this.wrapped.isOpen();
        }
    }
}

