package org.lsst.ccs.utilities.location;

/**
 * An Enumeration used to define the Camera.
 * 
 * @author The LSST CCS Team
 */
public enum Camera {

    LSSTCAM, AUXTEL, COMCAM, TS8;

    /**
     * Try to guess the camera based on the DAQ partition name
     * @param partition The DAQ partition name
     * @return The corresponding camera
     * @throws RuntimeException if the partition is not recognized
     */
    public static Camera forDaqPartition(String partition) {
        switch (partition) {
            case "lsstcam":
            case "camera":
            case "guider":
            case "bts":
                return LSSTCAM;
            case "comcam":
                return COMCAM;
            case "lat":
                return AUXTEL;
            case "ts8":
                return TS8;
            default:
                throw new RuntimeException("Unrecognized DAQ partition: "+partition);
        }
    }
}
