package org.lsst.ccs.utilities.image;

import java.util.List;

/**
 * Represents a set of images read from the DAQ. Each image typically contains
 * the data from a single amplifier, and is written to its own extended HDU in 
 * a fits file.
 * 
 * @author tonyj
 */
public interface ImageSet {
    
    /**
     * The list of the image extension names to be written in the fits file.
     * Each extensions is assumed to be the same size.
     * @return The ordered list of image extension names.
     */
    List<String> getImageExtensionNames();
    /**
     * This is the serial size of each image extension
     * @return The number of pixels in the serial direction
     */ 
    int getSerialPixels();
    /**
     * This is the parallel size of each image extension
     * @return The number of pixels in the parallel direction
     */ 
    int getParallelPixels();
}
