package org.lsst.ccs.utilities.ccd;

/**
 * A Wavefront CCD type.
 * This class contains the Wavefront constants as defined in LCA-13501.
 * 
 * @author The LSST CCS Team
 */
public class WFCCDType extends CCDType{

    /**
     * Create an ITL CCDType object.
     * 
     */
    public WFCCDType() {    
        super("wf","4400",new CCDGeometryConstants(new SegmentGeometryConstants(2000,509,3),49,63, 1, 8));
    }
    
    @Override
    public String getManufacturer() {
        return "itl";
    }
}
