/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataOutput;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.image.AsyncBufferedFile;
import org.lsst.ccs.utilities.image.CompositeFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.HeaderWriter;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsFileWriter
implements Closeable {
    private final AsyncBufferedFile abf;
    private final AsynchronousFileChannel asynchChannel;
    private final Map<String, ImageExtension> imageExtensions;
    private final File file;
    private static final Logger LOG = Logger.getLogger(FitsFileWriter.class.getName());

    private void initializeFitsFileWriter(ImageSet images, MetaDataSet metaDataSet, Map<String, HeaderSpecification> config, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        Header header;
        ArrayList<FitsHeaderMetadataProvider> inner_providers = new ArrayList<FitsHeaderMetadataProvider>();
        if (providers != null) {
            inner_providers.addAll(providers);
        }
        CompositeFitsHeaderMetadataProvider inner_provider = new CompositeFitsHeaderMetadataProvider(inner_providers);
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == RawImageData.BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        FitsFactory.setUseHierarch((boolean)true);
        MetaDataSet fullMetaData = inner_provider.getPrimaryHeaderMetadata();
        if (metaDataSet != null) {
            fullMetaData.addMetaDataSet(metaDataSet);
        }
        BasicHDU primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", fullMetaData, config);
        FitsCheckSum.setChecksum(primary);
        primary.getHeader().write((ArrayDataOutput)this.abf);
        int serialPixels = images.getSerialPixels();
        int parallelPixels = images.getParallelPixels();
        for (String imageExtensionName : images.getImageExtensionNames()) {
            BasicHDU hdu = FitsFactory.hduFactory((Object)dummyData);
            MetaDataSet extendedMetadata = inner_provider.getDataExtendedHeaderMetadata(imageExtensionName);
            if (metaDataSet != null) {
                extendedMetadata.addMetaDataSet(metaDataSet);
            }
            extendedMetadata.addMetaData("extension", "NAXIS", 2);
            extendedMetadata.addMetaData("extension", "NAXIS1", images.getSerialPixels());
            extendedMetadata.addMetaData("extension", "NAXIS2", images.getParallelPixels());
            this.addMetaDataToHeader(hdu, "extended", extendedMetadata, config);
            if (bits == RawImageData.BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 32768, "Unsigned 16 bit data");
            } else {
                hdu.addValue("BSCALE", 1.0, "");
                hdu.addValue("BZERO", 0.0, "");
            }
            header = hdu.getHeader();
            header.setXtension("IMAGE");
            FitsCheckSum.setChecksum(hdu);
            long startHeader = this.abf.getFilePointer();
            header.write((ArrayDataOutput)this.abf);
            long startData = this.abf.getFilePointer();
            long imageSize = bits.bytes() * serialPixels * parallelPixels;
            this.abf.seek(this.abf.getFilePointer() + imageSize);
            FitsUtil.pad((ArrayDataOutput)this.abf, (long)imageSize);
            this.imageExtensions.put(imageExtensionName, new ImageExtension(startHeader, startData, imageSize, header));
        }
        FitsFactory.setUseAsciiTables((boolean)false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU binary = FitsFactory.hduFactory((Object)tableDummyData);
            MetaDataSet additionalMetaData = inner_provider.getAdditionalExtendedHeaderMetadata(key);
            if (metaDataSet != null) {
                additionalMetaData.addMetaDataSet(metaDataSet);
            }
            this.addMetaDataToHeader(binary, key, additionalMetaData, config);
            header = binary.getHeader();
            header.setXtension("BINTABLE");
            FitsCheckSum.setChecksum(binary);
            header.write((ArrayDataOutput)this.abf);
        }
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images) throws IOException, FitsException {
        this(file, images, null, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, HeaderSpecification> specs) throws IOException, FitsException {
        this(file, images, null, null, RawImageData.BitsPerPixel.BIT32, specs);
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet) throws IOException, FitsException {
        this(file, images, metaDataSet, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, HeaderSpecification> specs, MetaDataSet metaDataSet) throws IOException, FitsException {
        this(file, images, metaDataSet, null, RawImageData.BitsPerPixel.BIT32, specs);
    }

    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, metaDataSet, providers, RawImageData.BitsPerPixel.BIT32);
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, null, providers, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, HeaderSpecification> specs, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, null, providers, RawImageData.BitsPerPixel.BIT32, specs);
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        this(file, images, metaDataSet, providers, bits, FitsHeadersSpecifications.getHeaderSpecifications());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits, Map<String, HeaderSpecification> specs) throws IOException, FitsException {
        Logger log = Logger.getLogger("nom.tam.fits");
        log.setLevel(Level.WARNING);
        this.file = file;
        this.asynchChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        this.abf = new AsyncBufferedFile(this.asynchChannel);
        this.imageExtensions = new HashMap<String, ImageExtension>();
        AsyncBufferedFile asyncBufferedFile = this.abf;
        synchronized (asyncBufferedFile) {
            this.initializeFitsFileWriter(images, metaDataSet, specs, providers, bits);
        }
    }

    public FitsFileWriter(File file) throws IOException {
        this.file = file;
        long start = System.currentTimeMillis();
        this.asynchChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        LOG.log(Level.FINE, () -> String.format("Open of %s took %,dms", file, System.currentTimeMillis() - start));
        this.abf = new AsyncBufferedFile(this.asynchChannel);
        this.imageExtensions = new HashMap<String, ImageExtension>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createHDUs(ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits, Map<String, HeaderSpecification> specs) throws IOException, FitsException {
        AsyncBufferedFile asyncBufferedFile = this.abf;
        synchronized (asyncBufferedFile) {
            this.initializeFitsFileWriter(images, metaDataSet, specs, providers, bits);
        }
    }

    public int write(String imageExtensionName, ByteBuffer src) throws IOException {
        Future write = this.getImageExtensionForName(imageExtensionName).write(src);
        try {
            return (Integer)write.get();
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new FitsIOException(this.file, (Throwable)x, "Exception while writing FITS file", new Object[0]);
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException("Interupt while writing FITS file");
        }
    }

    public Future<Integer> asyncWrite(String imageExtensionName, ByteBuffer src) throws IOException {
        return this.getImageExtensionForName(imageExtensionName).write(src);
    }

    public <A> void asyncWrite(String imageExtensionName, ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) throws IOException {
        this.getImageExtensionForName(imageExtensionName).write(src, attachment, handler);
    }

    private ImageExtension getImageExtensionForName(String imageExtensionName) {
        ImageExtension result = this.imageExtensions.get(imageExtensionName);
        if (result == null) {
            throw new IllegalArgumentException("Invalid image xtension name: " + imageExtensionName);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        for (ImageExtension imageExtension : this.imageExtensions.values()) {
            imageExtension.close();
        }
        this.abf.close();
        this.asynchChannel.close();
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, MetaDataSet metaDataSet, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        LOG.log(Level.FINE, "Writing out fits header {0} from header list: {1}", new Object[]{specName, config.keySet()});
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new FitsIOException(this.file, "Missing specification for header: %s", specName);
        }
        HeaderWriter.addMetaDataToHeader(this.file, hdu, spec, metaDataSet);
    }

    public static class FitsIOException
    extends IOException {
        FitsIOException(File file, Throwable cause, String message, Object ... args) {
            super("Error writing " + file + " : " + String.format(message, args), cause);
        }

        FitsIOException(File file, String message, Object ... args) {
            this(file, null, message, args);
        }
    }

    private class ImageExtension
    implements Closeable {
        private final long startHeader;
        private final long endPosition;
        private long currentPosition;
        private final FitsCheckSum.Checksum checkSum;
        private final Header header;

        private ImageExtension(long startHeader, long startData, long imageSize, Header header) throws IOException {
            this.startHeader = startHeader;
            this.currentPosition = startData;
            this.endPosition = startData + imageSize;
            this.header = header;
            this.checkSum = new FitsCheckSum.Checksum();
        }

        private synchronized Future<Integer> write(ByteBuffer src) throws IOException {
            int length = src.remaining();
            if ((long)length + this.currentPosition > this.endPosition) {
                throw new FitsIOException(FitsFileWriter.this.file, "Error writing file: %s, data received (%,d bytes) > expected length (%,d bytes)", (long)length + this.currentPosition, this.endPosition);
            }
            FitsCheckSum.updateChecksum(src, this.checkSum);
            Future<Integer> future = FitsFileWriter.this.asynchChannel.write(src, this.currentPosition);
            this.currentPosition += (long)length;
            return future;
        }

        private synchronized <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) throws IOException {
            int length = src.remaining();
            if ((long)length + this.currentPosition > this.endPosition) {
                throw new FitsIOException(FitsFileWriter.this.file, "Error writing file: %s, data received (%,d bytes) > expected length (%,d bytes)", (long)length + this.currentPosition, this.endPosition);
            }
            FitsCheckSum.updateChecksum(src, this.checkSum);
            FitsFileWriter.this.asynchChannel.write(src, this.currentPosition, attachment, handler);
            this.currentPosition += (long)length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void updateDataSum() throws IOException {
            try {
                FitsCheckSum.updateDataSum(this.header, this.checkSum.getCheckSum());
                AsyncBufferedFile asyncBufferedFile = FitsFileWriter.this.abf;
                synchronized (asyncBufferedFile) {
                    FitsFileWriter.this.abf.seek(this.startHeader);
                    this.header.write((ArrayDataOutput)FitsFileWriter.this.abf);
                }
            }
            catch (FitsException ex) {
                throw new FitsIOException(FitsFileWriter.this.file, (Throwable)ex, "Unable to add datasum to header", new Object[0]);
            }
        }

        @Override
        public void close() throws IOException {
            this.updateDataSum();
        }
    }
}

