/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.time.Instant;
import java.util.Date;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class DateUtils {
    private DateUtils() {
    }

    private static Date convertTemporalToDate(Object temporalObject) {
        if (temporalObject instanceof Date) {
            return (Date)temporalObject;
        }
        if (temporalObject instanceof Instant) {
            return Date.from((Instant)temporalObject);
        }
        if (temporalObject instanceof CCSTimeStamp) {
            return Date.from(((CCSTimeStamp)temporalObject).getTAIInstant());
        }
        throw new IllegalArgumentException("Unsupported temporal class: " + temporalObject);
    }

    public static double convertDateToMJD(Object temporalObject) {
        return DateUtils.convertDateToMJD(DateUtils.convertTemporalToDate(temporalObject));
    }

    public static String convertDateToString(Object temporalObject) {
        return DateUtils.convertDateToString(DateUtils.convertTemporalToDate(temporalObject));
    }

    public static double convertDateToMJD(Date date) {
        return (double)date.getTime() / 1000.0 / 86400.0 + 2440587.5 - 2400000.5;
    }

    static String convertDateToString(Date date) {
        return FitsDate.getFitsDateString((Date)date);
    }

    public static Date convertStringToDate(String string) throws FitsException {
        return new FitsDate(string).toDate();
    }
}

