package org.lsst.ccs.imagenaming;

/**
 * An enumeration of possible image sources.
 */
public enum Source {
    MainCamera("MC", false), 
    ComCam("CC", false), 
    AuxTel("AT", false), 
    TestStand("TS", false), 
    GenericCamera("GC", true),
    FiberSpectrograph("FS", true),
    Electrometer("EM", true),
    Block("BL", true);
    private final String code;
    private final boolean isIndexed;

    private Source(String code, boolean isIndexed) {
        this.code = code;
        this.isIndexed = isIndexed;
    }

    /**
     * The two-letter code for the image source
     *
     * @return The code.
     */
    public String getCode() {
        return code;
    }

    public boolean isIndexed() {
        return isIndexed;
    }

    static Source fromCode(String code) {
        for (Source s : Source.values()) {
            if (s.getCode().equals(code)) {
                return s;
            }
        }
        throw new IllegalArgumentException("Invalid source code: " + code);
    }
}
