package org.lsst.ccs.utilities.readout;

import java.util.Arrays;
import java.util.List;

/**
 * Specifies the mapping of DAQ readout register names to indexes
 * @author tonyj
 */
public class ReadOutRegisterMap {

    private final List<String> registerNames;

    /** 
     * Create a ReadOutRegisterMap from an ordered list of registerNames
     * @param registerNames 
     */
    public ReadOutRegisterMap(String[] registerNames) {
        this.registerNames = Arrays.asList(registerNames);
    }

    /**
     * Get the index of the named register
     * @param name The name to look for
     * @return The index
     * @throws IllegalArgumentException If the name is not found
     */
    public int getIndex(String name) {
        int result = registerNames.indexOf(name);
        if (result < 0) {
            throw new IllegalArgumentException("Unknown register name " + name);
        }
        return result;
    }

    int size() {
        return registerNames.size();
    }

    boolean contains(String name) {
        return registerNames.indexOf(name) >= 0;
    }

    Iterable<String> getNames() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
}
