/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CornerRaft;
import org.lsst.ccs.utilities.ccd.GuiderCCD;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.WFCCDType;
import org.lsst.ccs.utilities.ccd.WavefrontCCD;

public class CCDOrderTest {
    @Test
    public void testCCDOrder() {
        CornerRaft r = CornerRaft.createCornerRaft((CornerRaft.CornerRaftPosition)CornerRaft.CornerRaftPosition.CR04);
        boolean isfirst = true;
        for (Reb reb : r.getRebs()) {
            for (CCD ccd : reb.getCCDs()) {
                if (!(ccd.getType() instanceof WFCCDType)) continue;
                Assert.assertEquals((Object)(isfirst ? "SW0" : "SW1"), (Object)ccd.getName());
                Assert.assertEquals((long)(isfirst ? 0L : 1L), (long)ccd.getSerialPosition());
                isfirst = false;
            }
        }
    }

    @Test
    public void testGettingSegmentsByName() {
        CornerRaft r = CornerRaft.createCornerRaft((CornerRaft.CornerRaftPosition)CornerRaft.CornerRaftPosition.CR04);
        WavefrontCCD wf = (WavefrontCCD)((Reb)r.getRebs().get(0)).getCCDs().get(0);
        Assert.assertNotNull((Object)wf.getSegmentByName("Segment10"));
        Assert.assertNotNull((Object)wf.getSegmentByName("Seg14"));
        try {
            wf.getSegmentByName("Segment00");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GuiderCCD g = (GuiderCCD)((Reb)r.getRebs().get(1)).getCCDs().get(0);
        Assert.assertNotNull((Object)g.getSegmentByName("Segment10"));
        Assert.assertNotNull((Object)g.getSegmentByName("Seg00"));
    }
}

