
package org.lsst.ccs.utilities.image;

/**
 * Interface for data that can provide pixel data level image data.
 * This interface allows to access data in a rectangular pixel geometry, pixel by pixel.
 * To simplify matters the returned data samples are of type "int".
 * 
 * @author turri
 */
public interface ImagePixelData {
   
    
    /**
     * Get the width of the Image.
     * 
     * @return The image width.
     */
    public int getWidth();
    
    /**
     * Get the height of the Image.
     * 
     * @return The image height.
     */
    public int getHeight();
    
    /**
     * Get the data sample for pixel (x,y).
     * 
     * @param x the x coordinate of the pixel.
     * @param y the y coordinate of the pixel.
     * @return the value of pixel (x,y)
     */
    public int getPixelData(int x, int y);

    
    /**
     * Get the maximum value of the contained data.
     * This is used so that we can render the image on the screen in gray scale.
     * Double.NaN should be returned if the maximum value cannot be calculated.
     * 
     * @return The max value of the data if available. Double.NaN otherwise.
     */
    default public double getMaxValue() {
        return Double.NaN;
    }
    
}
