/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousFileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.RandomAccess;

class AsyncBufferedFile
implements ArrayDataOutput,
RandomAccess {
    private static final int BUFFER_SIZE = 32768;
    private final AsynchronousFileChannel channel;
    private ByteBuffer currentBuffer;
    private long currentBufferPosition;
    private final List<BufferRecord> records = new ArrayList<BufferRecord>();

    AsyncBufferedFile(AsynchronousFileChannel channel) {
        this.channel = channel;
        this.currentBufferPosition = 0L;
        this.currentBuffer = ByteBuffer.allocateDirect(32768);
        this.currentBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    private void commitRecord(long currentBufferPosition, ByteBuffer currentBuffer) throws IOException {
        for (BufferRecord r : this.records) {
            if (!r.overlaps(currentBufferPosition, currentBuffer.limit())) continue;
            r.waitForCompletion();
        }
        this.records.add(new BufferRecord(currentBufferPosition, currentBuffer.limit(), this.channel.write(currentBuffer, currentBufferPosition)));
    }

    public void flush() throws IOException {
        this.flush(32768);
    }

    private void flush(int newBufferSize) throws IOException {
        if (this.currentBuffer.position() > 0) {
            long newBufferPosition = this.currentBufferPosition + (long)this.currentBuffer.position();
            this.currentBuffer.flip();
            this.commitRecord(this.currentBufferPosition, this.currentBuffer);
            if (newBufferSize > 0) {
                this.currentBufferPosition = newBufferPosition;
                this.currentBuffer = ByteBuffer.allocateDirect(newBufferSize);
                this.currentBuffer.order(ByteOrder.BIG_ENDIAN);
            }
        } else if (newBufferSize > this.currentBuffer.capacity()) {
            this.currentBuffer = ByteBuffer.allocateDirect(newBufferSize);
            this.currentBuffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    private void needBytes(int bytes) throws IOException {
        if (this.currentBuffer.remaining() < bytes) {
            this.flush(Math.max(32768, bytes));
        }
    }

    public void write(boolean[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(boolean[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeBoolean(data[i]);
        }
    }

    public void write(char[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(char[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeChar(data[i]);
        }
    }

    public void write(double[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(double[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeDouble(data[i]);
        }
    }

    public void write(float[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(float[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeFloat(data[i]);
        }
    }

    public void write(int[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(int[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeInt(data[i]);
        }
    }

    public void write(long[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(long[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeLong(data[i]);
        }
    }

    public void write(short[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(short[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeShort(data[i]);
        }
    }

    public void write(String[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(String[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.write(AsciiFuncs.getBytes((String)data[i]), 0, data[i].length());
        }
    }

    public void writeArray(Object data) throws IOException {
        if (!data.getClass().isArray()) {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.write" + data.getClass().getName());
        }
        int length = Array.getLength(data);
        if (data.getClass().getComponentType().isArray()) {
            for (int i = 0; i < length; ++i) {
                this.writeArray(Array.get(data, i));
            }
        } else if (data instanceof boolean[]) {
            this.write((boolean[])data, 0, length);
        } else if (data instanceof byte[]) {
            this.write((byte[])data, 0, length);
        } else if (data instanceof char[]) {
            this.write((char[])data, 0, length);
        } else if (data instanceof short[]) {
            this.write((short[])data, 0, length);
        } else if (data instanceof int[]) {
            this.write((int[])data, 0, length);
        } else if (data instanceof long[]) {
            this.write((long[])data, 0, length);
        } else if (data instanceof float[]) {
            this.write((float[])data, 0, length);
        } else if (data instanceof double[]) {
            this.write((double[])data, 0, length);
        } else if (data instanceof String[]) {
            this.write((String[])data, 0, length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.writeArray(Array.get(data, i));
            }
        }
    }

    public void write(int data) throws IOException {
        this.needBytes(4);
        this.currentBuffer.putInt(data);
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        this.needBytes(length);
        this.currentBuffer.put(data, offset, length);
    }

    public void writeBoolean(boolean data) throws IOException {
        this.needBytes(1);
        this.currentBuffer.put(data ? (byte)1 : 0);
    }

    public void writeByte(int data) throws IOException {
        this.needBytes(1);
        this.currentBuffer.put((byte)data);
    }

    public void writeShort(int data) throws IOException {
        this.needBytes(2);
        this.currentBuffer.putShort((short)data);
    }

    public void writeChar(int data) throws IOException {
        this.needBytes(2);
        this.currentBuffer.put((byte)(data >>> 8));
        this.currentBuffer.put((byte)data);
    }

    public void writeInt(int data) throws IOException {
        this.needBytes(4);
        this.currentBuffer.putInt(data);
    }

    public void writeLong(long data) throws IOException {
        this.needBytes(8);
        this.currentBuffer.putLong(data);
    }

    public void writeFloat(float data) throws IOException {
        this.needBytes(4);
        this.currentBuffer.putFloat(data);
    }

    public void writeDouble(double data) throws IOException {
        this.needBytes(8);
        this.currentBuffer.putDouble(data);
    }

    public void writeBytes(String data) throws IOException {
        this.write(AsciiFuncs.getBytes((String)data), 0, data.length());
    }

    public void writeChars(String data) throws IOException {
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(data.charAt(i));
        }
    }

    public void writeUTF(String data) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws IOException {
        this.flush(0);
        for (BufferRecord r : this.records) {
            r.waitForCompletion();
        }
    }

    public long getFilePointer() {
        return this.currentBufferPosition + (long)this.currentBuffer.position();
    }

    public void seek(long position) throws IOException {
        if (position > this.currentBufferPosition && position - this.currentBufferPosition < (long)this.currentBuffer.capacity()) {
            this.currentBuffer.position((int)(position - this.currentBufferPosition));
        } else {
            this.flush(0);
            this.currentBufferPosition = position;
            this.currentBuffer = ByteBuffer.allocateDirect(32768);
            this.currentBuffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    public void mark(int arg0) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long skip(long bytes) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void skipAllBytes(long arg0) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void skipAllBytes(int arg0) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int read(byte[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(boolean[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(boolean[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(char[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(char[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(double[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(double[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(float[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(float[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(int[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(int[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(long[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(long[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(short[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int read(short[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int readArray(Object arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public long readLArray(Object arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public void readFully(byte[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public void readFully(byte[] arg0) throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int skipBytes(int arg0) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean readBoolean() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public byte readByte() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public short readShort() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public char readChar() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public int readInt() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public long readLong() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public float readFloat() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public double readDouble() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException("write only file");
    }

    private static class BufferRecord {
        private final long position;
        private final long size;
        private final Future<Integer> future;

        public BufferRecord(long position, long size, Future<Integer> future) {
            this.position = position;
            this.size = size;
            this.future = future;
        }

        private void waitForCompletion() throws IOException {
            try {
                this.future.get();
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException("Interrupt during IO");
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException("Exception during FITS asynch IO", cause);
            }
        }

        private boolean overlaps(long position, int limit) {
            return position + (long)limit >= this.position && this.position + this.size < position;
        }
    }
}

