
package org.lsst.ccs.utilities.ccd.image.data;

import java.nio.ByteBuffer;

/**
 * A class for raw image data.
 * This data can be in 16 or 32 bits depending on the hardware.
 * 
 * @author turri
 */
public class RawImageData {
        
    private final BitsPerPixel sample;
    private final ByteBuffer data;

    public RawImageData(BitsPerPixel sample, ByteBuffer data) {
        this.sample = sample;
        this.data = data;
    }

    public BitsPerPixel getSample() {
        return sample;
    }

    public ByteBuffer getImageData() {
        return data;
    }

    /**
     * The bitness of the data.
     */
    public enum BitsPerPixel {

        BIT16(2), BIT32(4);
        private final int bytes;

        private BitsPerPixel(int bytes) {
            this.bytes = bytes;
        }

        public int bytes() {
            return bytes;
        }

        public int bits() {
            return 8 * bytes;
        }
    };    
    
    
}
