package org.lsst.ccs.utilities.readout;

import java.util.List;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.image.DefaultImageSet;

/**
 * Utility class to build an ImageSet given a CCD and the corresponding
 * ReadoutParameters.
 * 
 * @author The LSST CCS Team
 */
public class ReadOutImageSet extends DefaultImageSet {
    
    public ReadOutImageSet(List<String> imageExtensionNames, ReadOutParameters rop) {
        super(imageExtensionNames, rop.getSerialReadPixels(), rop.getParallelReadPixels());
    }    
    
    @Deprecated
    public ReadOutImageSet(CCD ccd, ReadOutParameters rop) {
        super(ccd.getSegmentNames(), rop.getSerialReadPixels(), rop.getParallelReadPixels());
    }
    
}
