/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class Raft
extends Geometry<CCD> {
    private final RaftGeometryConstants raftConstants;
    private CCDType ccdType;
    protected final List<Reb> rebList = new ArrayList<Reb>();

    public Raft(CCDType type) {
        this(RaftGeometryConstants.createRaftGeometryConstants(type), type);
    }

    Raft(RaftGeometryConstants raftConstants, CCDType type) {
        super("R", new Dimension(raftConstants.getRaftx(), raftConstants.getRafty()), 3, 3);
        this.raftConstants = raftConstants;
        this.ccdType = type;
        this.populateRebList();
    }

    protected void populateRebList() {
        this.rebList.add(new Reb(Reb.RebType.SCIENCE, "Reb0", this));
        this.rebList.add(new Reb(Reb.RebType.SCIENCE, "Reb1", this));
        this.rebList.add(new Reb(Reb.RebType.SCIENCE, "Reb2", this));
    }

    public List<Reb> getRebs() {
        return this.rebList;
    }

    public void setCCDType(CCDType type) {
        for (Reb reb : this.rebList) {
            reb.setCCDType(type);
        }
    }

    @Override
    protected void addGeometryToGrid(CCD child, int p, int s) {
        int xCoord = (2 - p) * child.getWidth() + (2 - p) * this.raftConstants.getGap_inx() + (int)this.raftConstants.getGap_outx();
        int yCoord = (2 - s) * (child.getHeight() + this.raftConstants.getGap_iny()) + (int)this.raftConstants.getGap_outy();
        this.addGeometry(child, xCoord, yCoord);
        this.addCCDtoReb(child, p, s);
    }

    protected void addCCDtoReb(CCD child, int p, int s) {
        this.rebList.get(p).addCCD(child);
    }

    public RaftGeometryConstants getRaftGeometryConstants() {
        return this.raftConstants;
    }

    public static Raft createRaft(CCDType type) {
        Raft raft = new Raft(type);
        for (int i = 2; i >= 0; --i) {
            for (int j = 0; j < 3; ++j) {
                CCD ccd = CCD.createCCD(type);
                raft.addChildGeometry(ccd, i, j);
            }
        }
        return raft;
    }

    public static Raft createRaft(String definition) {
        Map props = (Map)InputConversionEngine.convertArgToType((String)definition, Map.class);
        String ccdTypeStr = props.getOrDefault("ccdType", "e2v").trim();
        CCDType ccdType = CCDType.getCCDType(ccdTypeStr);
        return Raft.createRaft(ccdType);
    }

    public CCDType getType() {
        return this.ccdType;
    }
}

