/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import java.util.HashMap;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.readout.WcsCoordinatesFitsHeaderMetadataProvider;

public class GeometryFitsHeaderMetadataProvider
implements FitsHeaderMetadataProvider {
    private final CCD ccd;
    private WcsCoordinatesFitsHeaderMetadataProvider provider;

    public GeometryFitsHeaderMetadataProvider(CCD ccd) {
        this.provider = new WcsCoordinatesFitsHeaderMetadataProvider(ccd);
        this.ccd = ccd;
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata() {
        MetaDataSet primaryHeaderMetadata = this.provider.getPrimaryHeaderMetadata();
        HashMap<String, Object> primaryMetaData = new HashMap<String, Object>();
        primaryMetaData.put("CCDSlot", this.ccd.getName());
        Raft raft = (Raft)this.ccd.getParent();
        if (raft != null) {
            primaryMetaData.put("RAFTBay", raft.getName());
        }
        primaryHeaderMetadata.addMetaDataMap("imageSet", primaryMetaData);
        return primaryHeaderMetadata;
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(int extendedIndex) {
        Segment segment = this.ccd.getSegments().get(extendedIndex);
        HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
        imageMetaData.put("EXTNAME", String.format("Segment%01d%01d", GeometryFitsHeaderMetadataProvider.getSegmentParallelPosition(segment), GeometryFitsHeaderMetadataProvider.getSegmentSerialPosition(segment)));
        imageMetaData.put("CHANNEL", segment.getChannel());
        imageMetaData.put("CCDSUM", "1 1");
        MetaDataSet metadata = this.provider.getDataExtendedHeaderMetadata(extendedIndex);
        metadata.addMetaDataMap("channel", imageMetaData);
        return metadata;
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
        return this.provider.getAdditionalExtendedHeaderMetadata(extendedKeyword);
    }

    private static int getSegmentParallelPosition(Segment seg) {
        return seg.getParallelPosition();
    }

    private static int getSegmentSerialPosition(Segment seg) {
        return seg.getSerialPosition();
    }
}

