/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.ImageSet;

public class RawImageConverter {
    private static final Logger logger = Logger.getLogger(RawImageConverter.class.getName());
    private final CCD geom;
    private final DefaultImageSet imageSet;
    private final BufferedImage rawImage;
    private static final int BUFFER_SIZE = 1000000;

    RawImageConverter(BufferedImage rawImage, CCD geom, int raftOffsetX, int raftOffsetY) {
        this.rawImage = rawImage;
        this.geom = geom;
        this.imageSet = new DefaultImageSet(geom);
    }

    ImageSet getImageSet() {
        return this.imageSet;
    }

    void pushDataToFile(FitsFileWriter writer) throws IOException {
        long start = System.currentTimeMillis();
        ByteBuffer dest = ByteBuffer.allocate(1000000);
        dest.order(ByteOrder.BIG_ENDIAN);
        for (Segment segment : this.geom.getSegments()) {
            BufferedImage sImage = new BufferedImage(this.imageSet.getNumberOfImages() * this.imageSet.getSerialPixels(), this.imageSet.getNumberOfImages() * this.imageSet.getParallelPixels(), 11);
            Graphics2D g2 = sImage.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, sImage.getWidth(), sImage.getHeight());
            BufferedImage aImage = this.rawImage.getSubimage(segment.getSerialPosition() * segment.getSegmentSerialActiveSize(), (1 - segment.getParallelPosition()) * segment.getSegmentParallelActiveSize(), segment.getSegmentSerialActiveSize(), segment.getSegmentParallelActiveSize());
            int h = segment.getSegmentParallelActiveSize();
            int w = segment.getSegmentSerialActiveSize();
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.drawImage(aImage, 0, 0, w, h, null);
            g2.dispose();
            WritableRaster data = sImage.getRaster();
            for (int col = 0; col < this.imageSet.getParallelPixels(); ++col) {
                for (int row = 0; row < this.imageSet.getSerialPixels(); ++row) {
                    int val = data.getSample(row, col, 0);
                    dest.putInt(val);
                    if (dest.hasRemaining()) continue;
                    dest.flip();
                    writer.write(segment.getChannel() - 1, dest);
                    dest.clear();
                }
            }
            dest.flip();
            writer.write(segment.getChannel() - 1, dest);
            dest.clear();
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.INFO, "Wrote image in {0}ms", stop - start);
    }
}

