/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.image.CompositeFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.GeometryFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsFileWriter
implements Closeable {
    private BufferedFile bf;
    private ImageExtension[] imageExtensions;

    private void initializeFitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, Map<String, HeaderSpecification> config, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        ArrayList<FitsHeaderMetadataProvider> inner_providers = new ArrayList<FitsHeaderMetadataProvider>();
        GeometryFitsHeaderMetadataProvider geometryProvider = new GeometryFitsHeaderMetadataProvider();
        inner_providers.add(geometryProvider);
        if (providers != null) {
            inner_providers.addAll(providers);
        }
        CompositeFitsHeaderMetadataProvider inner_provider = new CompositeFitsHeaderMetadataProvider(inner_providers);
        this.imageExtensions = new ImageExtension[images.getNumberOfImages()];
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == RawImageData.BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        this.bf = new BufferedFile(file, "rw");
        FitsFactory.setUseHierarch((boolean)true);
        MetaDataSet fullMetaData = inner_provider.getPrimaryHeaderMetadata(images);
        if (metaDataSet != null) {
            fullMetaData.addMetaDataSet(metaDataSet);
        }
        BasicHDU primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", fullMetaData, config);
        FitsCheckSum.setChecksum(primary);
        primary.getHeader().write((ArrayDataOutput)this.bf);
        int serialPixels = images.getReadOutParameters().getSerialReadPixels();
        int parallelPixels = images.getReadOutParameters().getParallelReadPixels();
        for (int i = 0; i < images.getNumberOfImages(); ++i) {
            BasicHDU hdu = FitsFactory.HDUFactory((Object)dummyData);
            MetaDataSet extendedMetadata = inner_provider.getDataExtendedHeaderMetadata(images, i);
            if (metaDataSet != null) {
                extendedMetadata.addMetaDataSet(metaDataSet);
            }
            this.addMetaDataToHeader(hdu, "extended", extendedMetadata, config);
            if (bits == RawImageData.BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 32768, "Unsigned 16 bit data");
            } else {
                hdu.addValue("BSCALE", 1.0, "");
                hdu.addValue("BZERO", 0.0, "");
            }
            Header header = hdu.getHeader();
            header.setXtension("IMAGE");
            FitsCheckSum.setChecksum(hdu);
            long start = this.bf.getFilePointer();
            header.write((ArrayDataOutput)this.bf);
            long current = this.bf.getFilePointer();
            long imageSize = bits.bytes() * serialPixels * parallelPixels;
            this.bf.seek(this.bf.getFilePointer() + imageSize);
            FitsUtil.pad((ArrayDataOutput)this.bf, (long)imageSize);
            BufferedFile imageExtensionBufferedFile = new BufferedFile(file, "rw");
            imageExtensionBufferedFile.seek(this.bf.getFilePointer());
            this.imageExtensions[i] = new ImageExtension(imageExtensionBufferedFile, start, current, header);
        }
        FitsFactory.setUseAsciiTables((boolean)false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU binary = FitsFactory.HDUFactory((Object)tableDummyData);
            MetaDataSet additionalMetaData = inner_provider.getAdditionalExtendedHeaderMetadata(images, key);
            if (metaDataSet != null) {
                additionalMetaData.addMetaDataSet(metaDataSet);
            }
            this.addMetaDataToHeader(binary, key, additionalMetaData, config);
            Header header = binary.getHeader();
            header.setXtension("BINTABLE");
            FitsCheckSum.setChecksum(binary);
            header.write((ArrayDataOutput)this.bf);
        }
        inner_provider.completedHeaderMetadata(images);
    }

    public FitsFileWriter(File file, ImageSet images) throws IOException, FitsException {
        this(file, images, null, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet) throws IOException, FitsException {
        this(file, images, metaDataSet, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, metaDataSet, providers, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, null, providers, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        this.initializeFitsFileWriter(file, images, metaDataSet, FitsHeadersSpecifications.getHeaderSpecifications(), providers, bits);
    }

    public void write(int imageIndex, ByteBuffer src) throws IOException {
        FutureTask future = this.imageExtensions[imageIndex].write(src);
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public FutureTask<Void> asyncWrite(int imageIndex, ByteBuffer src) throws IOException {
        return this.imageExtensions[imageIndex].write(src);
    }

    @Override
    public void close() throws IOException {
        for (ImageExtension imageExtension : this.imageExtensions) {
            imageExtension.updateDataSum();
        }
        this.bf.close();
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, MetaDataSet metaDataSet, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new IOException("Missing specification for header: " + specName);
        }
        for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            Object value = header.getValue(metaDataSet);
            try {
                if (value == null) continue;
                switch (header.getDataType()) {
                    case Integer: {
                        hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                        break;
                    }
                    case Float: {
                        double data = ((Number)value).doubleValue();
                        if (!Double.isFinite(data)) {
                            throw new IllegalArgumentException("Can not store non-finite floating point in FITS file");
                        }
                        hdu.addValue(header.getKeyword(), data, header.getComment());
                        break;
                    }
                    case Boolean: {
                        hdu.addValue(header.getKeyword(), ((Boolean)value).booleanValue(), header.getComment());
                        break;
                    }
                    case Date: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToString((Date)value), header.getComment());
                        break;
                    }
                    case MJD: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToMJD((Date)value), header.getComment());
                        break;
                    }
                    default: {
                        hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                    }
                }
            }
            catch (ClassCastException x) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()}));
            }
        }
    }

    private class ImageExtension {
        private final long startPosition;
        private final long endPosition;
        private long currentPosition;
        private final FitsCheckSum.Checksum checkSum;
        private final Header header;
        private final BufferedFile file;

        private ImageExtension(BufferedFile file, long start, long current, Header header) {
            this.startPosition = start;
            this.currentPosition = current;
            this.endPosition = file.getFilePointer();
            this.header = header;
            this.checkSum = new FitsCheckSum.Checksum();
            this.file = file;
        }

        private FutureTask<Void> write(ByteBuffer src) throws IOException {
            FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
                try {
                    int length = src.remaining();
                    if ((long)length + this.currentPosition > this.endPosition) {
                        throw new IOException("Too much data written for image " + length + " " + this.currentPosition + " " + this.endPosition);
                    }
                    FitsCheckSum.updateChecksum(src, this.checkSum);
                    this.file.seek(this.currentPosition);
                    if (src.hasArray()) {
                        this.file.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
                        src.position(src.limit());
                    } else {
                        while (src.remaining() > 0) {
                            this.file.write((int)src.get());
                        }
                    }
                    this.currentPosition += (long)length;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }, true);
            future.run();
            return future;
        }

        private void updateDataSum() throws IOException {
            try {
                FitsCheckSum.updateDataSum(this.header, this.checkSum.getCheckSum());
                this.file.seek(this.startPosition);
                this.header.write((ArrayDataOutput)this.file);
            }
            catch (FitsException ex) {
                throw new IOException("Unable to add datasum to header", ex);
            }
        }
    }
}

