/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

@RunWith(value=Parameterized.class)
public class FitsFileContentTest {
    private final CCDType type;

    @Parameterized.Parameters(name="{0}")
    public static List<CCDType> getProductionTypes() {
        ArrayList<CCDType> res = new ArrayList<CCDType>();
        res.add((CCDType)new E2VCCDType());
        res.add((CCDType)new ITLCCDType());
        return res;
    }

    public FitsFileContentTest(CCDType type) {
        this.type = type;
    }

    @Before
    public void prepareTests() {
        FitsHeadersSpecifications.loadDefaultSpecFiles();
    }

    @After
    public void cleanUpTests() {
        FitsHeadersSpecifications.removeAllHeaderSpecifications();
    }

    @Test
    public void testWrite() throws Exception {
        CCD ccd = CCD.createCCD((CCDType)this.type);
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)ccd, (String)"image", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)ccd, (GeneratedImage)generatedImage);
        String fileName = String.format(ccd.getType().getName() + "S%d%d", 0, 0);
        File file = new File("/tmp/" + fileName + ".fits");
        file.deleteOnExit();
        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCD)ccd);
        FitsFileWriter ffw = new FitsFileWriter(file, imageSet);
        for (Segment segment : ccd.getSegments()) {
            ffw.write(segment.getChannel() - 1, segment.getRawImageData(imageSet.getReadOutParameters()).getImageData());
        }
        try (Fits fits = new Fits(file);){
            fits.read();
            int expectedHDUs = 17;
            Assert.assertEquals((long)expectedHDUs, (long)fits.getNumberOfHDUs());
            for (int i = 1; i < fits.getNumberOfHDUs(); ++i) {
                BasicHDU hdu = fits.getHDU(i);
                Header header = hdu.getHeader();
                Assert.assertEquals((long)i, (long)Long.parseLong(header.findCard("CHANNEL").getValue()));
                String extensionName = "Segment" + (i < 9 ? 1 : 0) + (i < 9 ? i - 1 : 16 - i);
                Assert.assertEquals((Object)header.findCard("EXTNAME").getValue(), (Object)extensionName);
            }
        }
    }
}

