/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDTransform;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.CCDTypeUtils;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class CCDTypeTest {
    private final String[] itlDETSEC = new String[]{"[509:1,1:2000]", "[1018:510,1:2000]", "[1527:1019,1:2000]", "[2036:1528,1:2000]", "[2545:2037,1:2000]", "[3054:2546,1:2000]", "[3563:3055,1:2000]", "[4072:3564,1:2000]", "[4072:3564,4000:2001]", "[3563:3055,4000:2001]", "[3054:2546,4000:2001]", "[2545:2037,4000:2001]", "[2036:1528,4000:2001]", "[1527:1019,4000:2001]", "[1018:510,4000:2001]", "[509:1,4000:2001]"};
    private final int[] itlDTV1 = new int[]{510, 1019, 1528, 2037, 2546, 3055, 3564, 4073, 4073, 3564, 3055, 2546, 2037, 1528, 1019, 510};
    private final int[] itlDTV2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 4001, 4001, 4001, 4001, 4001, 4001, 4001, 4001};
    private final double[] itlDTM1_1 = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] itlDTM2_2 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] itlCRVAL1A = new double[]{2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] itlCRVAL2A = new double[]{507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0};
    private final double[] itlPC1_2A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] itlCRVAL1C = new double[]{4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] itlCRVAL2C = new double[]{507.0, 1016.0, 1525.0, 2034.0, 2543.0, 3052.0, 3561.0, 4070.0, 4070.0, 3561.0, 3052.0, 2543.0, 2034.0, 1525.0, 1016.0, 507.0};
    private final double[] itlPC1_2C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[][] itlCRVAL1R = new double[][]{{4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0}, {8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0}, {12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0}};
    private final double[][] itlCRVAL2R = new double[][]{{596.0, 1105.0, 1614.0, 2123.0, 2632.0, 3141.0, 3650.0, 4159.0, 4159.0, 3650.0, 3141.0, 2632.0, 2123.0, 1614.0, 1105.0, 596.0}, {4821.0, 5330.0, 5839.0, 6348.0, 6857.0, 7366.0, 7875.0, 8384.0, 8384.0, 7875.0, 7366.0, 6857.0, 6348.0, 5839.0, 5330.0, 4821.0}, {9046.0, 9555.0, 10064.0, 10573.0, 11082.0, 11591.0, 12100.0, 12609.0, 12609.0, 12100.0, 11591.0, 11082.0, 10573.0, 10064.0, 9555.0, 9046.0}};
    private final double[] itlPC1_2R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[][] itlCRVAL1F = new double[][]{{4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0}, {8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0}, {12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0}};
    private final double[][] itlCRVAL2F = new double[][]{{596.0, 1105.0, 1614.0, 2123.0, 2632.0, 3141.0, 3650.0, 4159.0, 4159.0, 3650.0, 3141.0, 2632.0, 2123.0, 1614.0, 1105.0, 596.0}, {4821.0, 5330.0, 5839.0, 6348.0, 6857.0, 7366.0, 7875.0, 8384.0, 8384.0, 7875.0, 7366.0, 6857.0, 6348.0, 5839.0, 5330.0, 4821.0}, {9046.0, 9555.0, 10064.0, 10573.0, 11082.0, 11591.0, 12100.0, 12609.0, 12609.0, 12100.0, 11591.0, 11082.0, 10573.0, 10064.0, 9555.0, 9046.0}};
    private final double[] itlPC1_2F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final String[] e2vDETSEC = new String[]{"[512:1,1:2002]", "[1024:513,1:2002]", "[1536:1025,1:2002]", "[2048:1537,1:2002]", "[2560:2049,1:2002]", "[3072:2561,1:2002]", "[3584:3073,1:2002]", "[4096:3585,1:2002]", "[3585:4096,4004:2003]", "[3073:3584,4004:2003]", "[2561:3072,4004:2003]", "[2049:2560,4004:2003]", "[1537:2048,4004:2003]", "[1025:1536,4004:2003]", "[513:1024,4004:2003]", "[1:512,4004:2003]"};
    private final int[] e2vDTV1 = new int[]{523, 1035, 1547, 2059, 2571, 3083, 3595, 4107, 3574, 3062, 2550, 2038, 1526, 1014, 502, -10};
    private final int[] e2vDTV2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 4005, 4005, 4005, 4005, 4005, 4005, 4005, 4005};
    private final double[] e2vDTM1_1 = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vDTM2_2 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] e2vCRVAL1A = new double[]{2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] e2vCRVAL2A = new double[]{523.0, 523.0, 523.0, 523.0, 523.0, 523.0, 523.0, 523.0, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0};
    private final double[] e2vPC1_2A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vCRVAL1C = new double[]{4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] e2vCRVAL2C = new double[]{523.0, 1035.0, 1547.0, 2059.0, 2571.0, 3083.0, 3595.0, 4107.0, 3574.0, 3062.0, 2550.0, 2038.0, 1526.0, 1014.0, 502.0, -10.0};
    private final double[] e2vPC1_2C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[][] e2vCRVAL1R = new double[][]{{4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0}, {8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0}, {12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0}};
    private final double[][] e2vCRVAL2R = new double[][]{{600.0, 1112.0, 1624.0, 2136.0, 2648.0, 3160.0, 3672.0, 4184.0, 3651.0, 3139.0, 2627.0, 2115.0, 1603.0, 1091.0, 579.0, 67.0}, {4825.0, 5337.0, 5849.0, 6361.0, 6873.0, 7385.0, 7897.0, 8409.0, 7876.0, 7364.0, 6852.0, 6340.0, 5828.0, 5316.0, 4804.0, 4292.0}, {9050.0, 9562.0, 10074.0, 10586.0, 11098.0, 11610.0, 12122.0, 12634.0, 12101.0, 11589.0, 11077.0, 10565.0, 10053.0, 9541.0, 9029.0, 8517.0}};
    private final double[] e2vPC1_2R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[][] e2vCRVAL1F = new double[][]{{4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0}, {8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0}, {12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0}};
    private final double[][] e2vCRVAL2F = new double[][]{{600.0, 1112.0, 1624.0, 2136.0, 2648.0, 3160.0, 3672.0, 4184.0, 3651.0, 3139.0, 2627.0, 2115.0, 1603.0, 1091.0, 579.0, 67.0}, {4825.0, 5337.0, 5849.0, 6361.0, 6873.0, 7385.0, 7897.0, 8409.0, 7876.0, 7364.0, 6852.0, 6340.0, 5828.0, 5316.0, 4804.0, 4292.0}, {9050.0, 9562.0, 10074.0, 10586.0, 11098.0, 11610.0, 12122.0, 12634.0, 12101.0, 11589.0, 11077.0, 10565.0, 10053.0, 9541.0, 9029.0, 8517.0}};
    private final double[] e2vPC1_2F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};

    @Test
    public void testCCDTypeConversion() {
        CCD ccd = CCD.createCCD((CCDType)new E2VCCDType());
        CCD newCcd = (CCD)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)ccd, (CCDType)new ITLCCDType());
        this.compareGeometries((Geometry)ccd, (Geometry)newCcd, false);
        CCD oldCcd = (CCD)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)newCcd, (CCDType)new E2VCCDType());
        this.compareGeometries((Geometry)ccd, (Geometry)oldCcd, true);
    }

    @Test
    public void testRebTypeConversion() {
        E2VCCDType e2v = new E2VCCDType();
        Reb reb = new Reb((CCDType)e2v);
        reb.addChildGeometry((Geometry)CCD.createCCD((CCDType)e2v), 0, 0);
        reb.addChildGeometry((Geometry)CCD.createCCD((CCDType)e2v), 0, 2);
        Reb newReb = (Reb)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)reb, (CCDType)new ITLCCDType());
        this.compareGeometries((Geometry)reb, (Geometry)newReb, false);
        Reb oldReb = (Reb)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)newReb, (CCDType)e2v);
        this.compareGeometries((Geometry)reb, (Geometry)oldReb, true);
    }

    @Test
    public void testRaftTypeConversion() {
        E2VCCDType e2v = new E2VCCDType();
        Reb reb1 = new Reb((CCDType)e2v);
        reb1.addChildGeometry((Geometry)CCD.createCCD((CCDType)e2v), 0, 0);
        reb1.addChildGeometry((Geometry)CCD.createCCD((CCDType)e2v), 0, 2);
        Reb reb2 = Reb.createReb((CCDType)e2v);
        Raft raft = new Raft((CCDType)e2v);
        raft.addChildGeometry((Geometry)reb1, 0, 0);
        raft.addChildGeometry((Geometry)reb2, 2, 0);
        ITLCCDType itl = new ITLCCDType();
        Raft newRaft = (Raft)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)raft, (CCDType)itl);
        this.compareGeometries((Geometry)raft, (Geometry)newRaft, false);
        Raft oldRaft = (Raft)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)newRaft, (CCDType)e2v);
        this.compareGeometries((Geometry)raft, (Geometry)oldRaft, true);
        Reb reb = (Reb)oldRaft.getChild(2, 0);
        String rebUniqueId = reb.getUniqueId();
        Reb newReb = (Reb)CCDTypeUtils.changeCCDTypeForGeometry((Geometry)reb, (CCDType)itl);
        TestCase.assertEquals((String)rebUniqueId, (String)newReb.getUniqueId());
    }

    private void compareGeometries(Geometry g1, Geometry g2, boolean sameType) {
        TestCase.assertEquals((int)g1.getNumberOfChildren(), (int)g2.getNumberOfChildren());
        TestCase.assertEquals((int)g1.getParallelChildrenCount(), (int)g2.getParallelChildrenCount());
        TestCase.assertEquals((int)g1.getSerialChildrenCount(), (int)g2.getSerialChildrenCount());
        TestCase.assertEquals((String)g1.getUniqueId(), (String)g2.getUniqueId());
        if (sameType) {
            TestCase.assertEquals((Object)g1.getDimension(), (Object)g2.getDimension());
        }
        for (int p = 0; p < g1.getParallelChildrenCount(); ++p) {
            for (int s = 0; s < g1.getSerialChildrenCount(); ++s) {
                Geometry child1 = g1.getChild(p, s);
                Geometry child2 = g2.getChild(p, s);
                if (child1 != null) {
                    this.compareGeometries(child1, child2, sameType);
                    continue;
                }
                Assert.assertNull((Object)child2);
            }
        }
    }

    @Test
    public void testE2V() {
        FocalPlane fp = new FocalPlane();
        E2VCCDType type = new E2VCCDType();
        Raft raft00 = Raft.createRaft((CCDType)type);
        fp.addChildGeometry((Geometry)raft00, 0, 0);
        Raft raft21 = Raft.createRaft((CCDType)type);
        fp.addChildGeometry((Geometry)raft21, 2, 1);
        for (Raft raft : fp.getChildrenList()) {
            for (int p = 0; p < raft.getParallelChildrenCount(); ++p) {
                Reb reb = (Reb)raft.getChild(p, 0);
                for (int s = 0; s < reb.getSerialChildrenCount(); ++s) {
                    CCD ccd = (CCD)reb.getChild(0, s);
                    this.testE2VInterface(ccd, p, s, raft.getParallelPosition(), raft.getSerialPosition(), true);
                    this.testSegmentOrder(ccd);
                }
            }
        }
    }

    @Test
    public void testE2VDimensions() {
        E2VCCDType ccd = new E2VCCDType();
        Assert.assertEquals((long)2002L, (long)ccd.getCCDGeometryConstants().getSegmentParallelActiveSize());
        Assert.assertEquals((long)512L, (long)ccd.getCCDGeometryConstants().getSegmentSerialActiveSize());
        Assert.assertEquals((long)4004L, (long)ccd.getCCDGeometryConstants().getActiveAreaParallelSize());
        Assert.assertEquals((long)4096L, (long)ccd.getCCDGeometryConstants().getActiveAreaSerialSize());
        Assert.assertEquals((long)4197L, (long)ccd.getCCDGeometryConstants().getPhysicalAreaParallelSize());
        Assert.assertEquals((long)4200L, (long)ccd.getCCDGeometryConstants().getPhysicalAreaSerialSize());
    }

    @Test
    public void testITLDimensions() {
        ITLCCDType ccd = new ITLCCDType();
        Assert.assertEquals((long)2000L, (long)ccd.getCCDGeometryConstants().getSegmentParallelActiveSize());
        Assert.assertEquals((long)509L, (long)ccd.getCCDGeometryConstants().getSegmentSerialActiveSize());
        Assert.assertEquals((long)4000L, (long)ccd.getCCDGeometryConstants().getActiveAreaParallelSize());
        Assert.assertEquals((long)4072L, (long)ccd.getCCDGeometryConstants().getActiveAreaSerialSize());
        Assert.assertEquals((long)4198L, (long)ccd.getCCDGeometryConstants().getPhysicalAreaParallelSize());
        Assert.assertEquals((long)4198L, (long)ccd.getCCDGeometryConstants().getPhysicalAreaSerialSize());
    }

    public void testE2VInterface(CCD ccd, int cp, int cs, int rp, int rs, boolean testRaftValues) {
        CCDType type = ccd.getType();
        ReadOutParameters readOutParameters = new ReadOutParameters(type);
        Map primaryHeader = FitsHeaderUtilities.getCCDPrimaryHeaders((CCD)ccd);
        TestCase.assertEquals((Object)"[1:4096,1:4004]", primaryHeader.get("DETSIZE"));
        int seg = 0;
        for (Segment segment : ccd.getSegments()) {
            int p = segment.getParallelPosition();
            int s = segment.getSerialPosition();
            Map header = FitsHeaderUtilities.getSegmentHeaders((Segment)segment, (ReadOutParameters)readOutParameters);
            TestCase.assertEquals((Object)2, header.get("NAXIS"));
            TestCase.assertEquals((Object)544, header.get("NAXIS1"));
            TestCase.assertEquals((Object)2048, header.get("NAXIS2"));
            TestCase.assertEquals((Object)"[1:4096,1:4004]", header.get("DETSIZE"));
            TestCase.assertEquals((Object)("Segment" + p + s), header.get("EXTNAME"));
            TestCase.assertEquals((Object)this.e2vDETSEC[seg], header.get("DETSEC"));
            TestCase.assertEquals((Object)"[11:522,1:2002]", header.get("DATASEC"));
            TestCase.assertEquals((Object)this.e2vDTV1[seg], header.get("DTV1"));
            TestCase.assertEquals((Object)this.e2vDTV2[seg], header.get("DTV2"));
            TestCase.assertEquals((Object)this.e2vDTM1_1[seg], header.get("DTM1_1"));
            TestCase.assertEquals((Object)this.e2vDTM2_2[seg], header.get("DTM2_2"));
            TestCase.assertEquals((Object)this.e2vCRVAL1A[seg], header.get("CRVAL1A"));
            TestCase.assertEquals((Object)this.e2vCRVAL2A[seg], header.get("CRVAL2A"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC1_2A"));
            TestCase.assertEquals((Object)this.e2vPC2_1A[seg], header.get("PC2_1A"));
            TestCase.assertEquals((Object)this.e2vCRVAL1C[seg], header.get("CRVAL1C"));
            TestCase.assertEquals((Object)this.e2vCRVAL2C[seg], header.get("CRVAL2C"));
            TestCase.assertEquals((Object)this.e2vPC1_2C[seg], header.get("PC1_2C"));
            TestCase.assertEquals((Object)this.e2vPC2_1C[seg], header.get("PC2_1C"));
            if (testRaftValues) {
                TestCase.assertEquals((Object)this.e2vCRVAL1R[cp][seg], header.get("CRVAL1R"));
                TestCase.assertEquals((Object)this.e2vCRVAL2R[cs][seg], header.get("CRVAL2R"));
                RaftGeometryConstants raftGeometryConstants = RaftGeometryConstants.createRaftGeometryConstants((CCDType)new E2VCCDType());
                TestCase.assertEquals((Object)(this.e2vCRVAL1F[cp][seg] + (double)(rp * raftGeometryConstants.getRaftx())), header.get("CRVAL1F"));
                TestCase.assertEquals((Object)(this.e2vCRVAL2F[cs][seg] + (double)(rs * raftGeometryConstants.getRafty())), header.get("CRVAL2F"));
                TestCase.assertEquals((Object)this.e2vCRVAL2R[cs][seg], header.get("CRVAL1Q"));
                TestCase.assertEquals((Object)this.e2vCRVAL1R[cp][seg], header.get("CRVAL2Q"));
            }
            TestCase.assertEquals((Object)this.e2vPC1_2R[seg], header.get("PC1_2R"));
            TestCase.assertEquals((Object)this.e2vPC2_1R[seg], header.get("PC2_1R"));
            TestCase.assertEquals((Object)this.e2vPC1_2F[seg], header.get("PC1_2F"));
            TestCase.assertEquals((Object)this.e2vPC2_1F[seg], header.get("PC2_1F"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC1_1B"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC2_2B"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC1_1Q"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC2_2Q"));
            TestCase.assertEquals((Object)this.e2vCRVAL2C[seg], header.get("CRVAL1B"));
            TestCase.assertEquals((Object)this.e2vCRVAL1C[seg], header.get("CRVAL2B"));
            this.testGeneralSegment(header, seg + 1);
            ++seg;
        }
    }

    @Test
    public void testITL() {
        FocalPlane fp = new FocalPlane();
        ITLCCDType type = new ITLCCDType();
        Raft raft00 = Raft.createRaft((CCDType)type);
        fp.addChildGeometry((Geometry)raft00, 0, 0);
        Raft raft43 = Raft.createRaft((CCDType)type);
        fp.addChildGeometry((Geometry)raft43, 4, 3);
        for (Raft raft : fp.getChildrenList()) {
            for (int p = 0; p < raft.getParallelChildrenCount(); ++p) {
                Reb reb = (Reb)raft.getChild(p, 0);
                for (int s = 0; s < reb.getSerialChildrenCount(); ++s) {
                    CCD ccd = (CCD)reb.getChild(0, s);
                    this.testITLInterface(ccd, p, s, raft.getParallelPosition(), raft.getSerialPosition(), true);
                    this.testSegmentOrder(ccd);
                }
            }
        }
    }

    public void testITLInterface(CCD ccd, int cp, int cs, int rp, int rs, boolean testRaftValues) {
        CCDType type = ccd.getType();
        ReadOutParameters readOutParameters = new ReadOutParameters(type);
        Map primaryHeader = FitsHeaderUtilities.getCCDPrimaryHeaders((CCD)ccd);
        TestCase.assertEquals((Object)"[1:4072,1:4000]", primaryHeader.get("DETSIZE"));
        int seg = 0;
        for (Segment segment : ccd.getSegments()) {
            int p = segment.getParallelPosition();
            int s = segment.getSerialPosition();
            Map header = FitsHeaderUtilities.getSegmentHeaders((Segment)segment, (ReadOutParameters)readOutParameters);
            TestCase.assertEquals((Object)2, header.get("NAXIS"));
            TestCase.assertEquals((Object)544, header.get("NAXIS1"));
            TestCase.assertEquals((Object)2048, header.get("NAXIS2"));
            TestCase.assertEquals((Object)"[1:4072,1:4000]", header.get("DETSIZE"));
            TestCase.assertEquals((Object)("Segment" + p + s), header.get("EXTNAME"));
            TestCase.assertEquals((Object)this.itlDETSEC[seg], header.get("DETSEC"));
            TestCase.assertEquals((Object)"[4:512,1:2000]", header.get("DATASEC"));
            TestCase.assertEquals((Object)this.itlDTV2[seg], header.get("DTV2"));
            TestCase.assertEquals((Object)this.itlDTM1_1[seg], header.get("DTM1_1"));
            TestCase.assertEquals((Object)this.itlDTM2_2[seg], header.get("DTM2_2"));
            TestCase.assertEquals((Object)this.itlCRVAL1A[seg], header.get("CRVAL1A"));
            TestCase.assertEquals((Object)this.itlCRVAL2A[seg], header.get("CRVAL2A"));
            TestCase.assertEquals((Object)this.itlPC1_2A[seg], header.get("PC1_2A"));
            TestCase.assertEquals((Object)this.itlPC2_1A[seg], header.get("PC2_1A"));
            TestCase.assertEquals((Object)this.itlCRVAL1C[seg], header.get("CRVAL1C"));
            TestCase.assertEquals((Object)this.itlCRVAL2C[seg], header.get("CRVAL2C"));
            TestCase.assertEquals((Object)this.itlPC1_2C[seg], header.get("PC1_2C"));
            TestCase.assertEquals((Object)this.itlPC2_1C[seg], header.get("PC2_1C"));
            if (testRaftValues) {
                TestCase.assertEquals((Object)this.itlCRVAL1R[cp][seg], header.get("CRVAL1R"));
                TestCase.assertEquals((Object)this.itlCRVAL2R[cs][seg], header.get("CRVAL2R"));
                RaftGeometryConstants raftGeometryConstants = RaftGeometryConstants.createRaftGeometryConstants((CCDType)new ITLCCDType());
                TestCase.assertEquals((Object)(this.itlCRVAL1F[cp][seg] + (double)(rp * raftGeometryConstants.getRaftx())), header.get("CRVAL1F"));
                TestCase.assertEquals((Object)(this.itlCRVAL2F[cs][seg] + (double)(rs * raftGeometryConstants.getRafty())), header.get("CRVAL2F"));
                TestCase.assertEquals((Object)this.itlCRVAL2R[cs][seg], header.get("CRVAL1Q"));
                TestCase.assertEquals((Object)this.itlCRVAL1R[cp][seg], header.get("CRVAL2Q"));
            }
            TestCase.assertEquals((Object)this.itlPC1_2R[seg], header.get("PC1_2R"));
            TestCase.assertEquals((Object)this.itlPC2_1R[seg], header.get("PC2_1R"));
            TestCase.assertEquals((Object)this.itlPC1_2F[seg], header.get("PC1_2F"));
            TestCase.assertEquals((Object)this.itlPC2_1F[seg], header.get("PC2_1F"));
            TestCase.assertEquals((Object)this.itlPC1_2A[seg], header.get("PC2_2B"));
            TestCase.assertEquals((Object)this.itlPC2_1A[seg], header.get("PC1_1B"));
            TestCase.assertEquals((Object)this.itlPC1_2A[seg], header.get("PC2_2Q"));
            TestCase.assertEquals((Object)this.itlPC2_1A[seg], header.get("PC1_1Q"));
            TestCase.assertEquals((Object)this.itlCRVAL2C[seg], header.get("CRVAL1B"));
            TestCase.assertEquals((Object)this.itlCRVAL1C[seg], header.get("CRVAL2B"));
            this.testGeneralSegment(header, seg + 1);
            ++seg;
        }
    }

    private void testGeneralSegment(Map<String, Object> header, int id) {
        TestCase.assertEquals((Object)id, (Object)header.get("CHANNEL"));
        TestCase.assertEquals((Object)"1 1", (Object)header.get("CCDSUM"));
    }

    @Test
    public void testE2VGlobalTranform() {
        E2VCCDType type = new E2VCCDType();
        CCD ccd1 = CCD.createCCD((CCDType)type);
        this.testGlobalTransform(ccd1);
    }

    @Test
    public void testITLGlobalTranform() {
        ITLCCDType type = new ITLCCDType();
        CCD ccd1 = CCD.createCCD((CCDType)type);
        this.testGlobalTransform(ccd1);
    }

    @Test
    public void testE2VActiveTranform() {
        E2VCCDType type = new E2VCCDType();
        CCD ccd1 = CCD.createCCD((CCDType)type);
        this.testActiveTransform(ccd1);
    }

    @Test
    public void testITLActiveTranform() {
        ITLCCDType type = new ITLCCDType();
        CCD ccd1 = CCD.createCCD((CCDType)type);
        this.testActiveTransform(ccd1);
    }

    private void testActiveTransform(CCD ccd) {
        CCDTransform local1 = CCDTransform.getActiveTransform((CCD)ccd);
        CCDTransform local2 = CCDTransform.getActiveTransform((CCD)ccd);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = r.nextInt(ccd.getActiveSerialSize());
            int y = r.nextInt(ccd.getActiveParallelSize());
            local1.setXY(x, y);
            local2.setSegmentSerialParallel(local1.getSegment(), local1.getSerial(), local1.getParallel());
            this.testEqual(local1, local2);
        }
    }

    private void testGlobalTransform(CCD ccd) {
        CCDTransform global1 = CCDTransform.getGlobalTransform((CCD)ccd);
        CCDTransform global2 = CCDTransform.getGlobalTransform((CCD)ccd);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = r.nextInt(ReadOutParameters.getCCDTotalSerialSize((CCD)ccd, (ReadOutParameters)global1.getReadOutParameters()));
            int y = r.nextInt(ReadOutParameters.getCCDTotalParallelSize((CCD)ccd, (ReadOutParameters)global1.getReadOutParameters()));
            global1.setXY(x, y);
            global2.setSegmentSerialParallel(global1.getSegment(), global1.getSerial(), global1.getParallel());
            this.testEqual(global1, global2);
        }
    }

    private void testEqual(CCDTransform global1, CCDTransform global2) {
        TestCase.assertEquals((int)global1.getX(), (int)global2.getX());
        TestCase.assertEquals((int)global1.getY(), (int)global2.getY());
        TestCase.assertEquals((int)global1.getGlobalX(), (int)global2.getGlobalX());
        TestCase.assertEquals((int)global1.getGlobalY(), (int)global2.getGlobalY());
        TestCase.assertEquals((Object)global1.getSegment(), (Object)global2.getSegment());
        TestCase.assertEquals((int)global1.getSerial(), (int)global2.getSerial());
        TestCase.assertEquals((int)global1.getParallel(), (int)global2.getParallel());
        TestCase.assertEquals((Object)global1.getPixelType(), (Object)global2.getPixelType());
    }

    @Test
    public void testE2V_CCDdesignators() {
        E2VCCDType type = new E2VCCDType();
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getSegmentParallelActiveSize(), (int)2002);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getSegmentSerialActiveSize(), (int)512);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getActiveAreaParallelSize(), (int)4004);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getActiveAreaSerialSize(), (int)4096);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getPhysicalAreaParallelSize(), (int)4197);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getPhysicalAreaSerialSize(), (int)4200);
        RaftGeometryConstants raftGeometryConstants = RaftGeometryConstants.createRaftGeometryConstants((CCDType)type);
        TestCase.assertEquals((int)raftGeometryConstants.getGap_inx(), (int)28);
        TestCase.assertEquals((int)raftGeometryConstants.getGap_iny(), (int)25);
        TestCase.assertEquals((Object)raftGeometryConstants.getGap_outx(), (Object)26.5);
        TestCase.assertEquals((Object)raftGeometryConstants.getGap_outy(), (Object)25.0);
        TestCase.assertEquals((int)raftGeometryConstants.getRaftx(), (int)12700);
        TestCase.assertEquals((int)raftGeometryConstants.getRafty(), (int)12700);
    }

    @Test
    public void testITL_CCDdesignators() {
        ITLCCDType type = new ITLCCDType();
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getSegmentParallelActiveSize(), (int)2000);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getSegmentSerialActiveSize(), (int)509);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getActiveAreaParallelSize(), (int)4000);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getActiveAreaSerialSize(), (int)4072);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getPhysicalAreaParallelSize(), (int)4198);
        TestCase.assertEquals((int)type.getCCDGeometryConstants().getPhysicalAreaSerialSize(), (int)4198);
        RaftGeometryConstants raftGeometryConstants = RaftGeometryConstants.createRaftGeometryConstants((CCDType)type);
        TestCase.assertEquals((int)raftGeometryConstants.getGap_inx(), (int)27);
        TestCase.assertEquals((int)raftGeometryConstants.getGap_iny(), (int)27);
        TestCase.assertEquals((Object)raftGeometryConstants.getGap_outx(), (Object)26.0);
        TestCase.assertEquals((Object)raftGeometryConstants.getGap_outx(), (Object)26.0);
        TestCase.assertEquals((int)raftGeometryConstants.getRaftx(), (int)12700);
        TestCase.assertEquals((int)raftGeometryConstants.getRafty(), (int)12700);
    }

    private void testSegmentOrder(CCD ccd) {
        List segments = ccd.getSegments();
        int count = 1;
        for (Segment s : segments) {
            TestCase.assertEquals((int)count, (int)s.getChannel());
            String name = "Seg";
            name = count < 9 ? name + "1" + (count - 1) : name + "0" + (16 - count);
            ++count;
            TestCase.assertEquals((String)name, (String)s.getName());
        }
        for (int i = 0; i < segments.size(); ++i) {
            TestCase.assertEquals((int)(i + 1), (int)((Segment)segments.get(i)).getChannel());
        }
    }
}

