/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class CCDDemo {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
        E2VCCDType type = new E2VCCDType();
        CCD ccd = CCD.createCCD((CCDType)type);
        CCDDemo.writeFitsFile(ccd);
        type = new ITLCCDType();
        ccd = CCD.createCCD((CCDType)type);
        CCDDemo.writeFitsFile(ccd);
    }

    private static void writeFitsFile(CCD ccd) throws InterruptedException, IOException, FitsException {
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)ccd, (String)"ripples", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)ccd, (GeneratedImage)generatedImage);
        String raftName = String.format(ccd.getType().getName() + "S%d%d", 0, 0);
        File raftFile = new File("/tmp/" + raftName + ".fits");
        Map primaryHeaders = FitsHeaderUtilities.getCCDPrimaryHeaders((CCD)ccd);
        primaryHeaders.put("Raft", primaryHeaders);
        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCD)ccd);
        FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet);
        for (Segment segment : ccd.getSegments()) {
            ffw.write(segment.getChannel() - 1, segment.getRawImageData(imageSet.getReadOutParameters()).getImageData());
        }
    }
}

