
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.image.ImagePixelData;


/**
 * Interface to be implemented by Geometry objects that can be exposed to 
 * a ImagePixelData.
 * 
 * This class is used when simulated images are generated over a geometry.
 * A simulated image is created for the whole geometry area, but only the
 * children that implement ImageSentiveArea are actually exposed to the generated
 * pixel data.
 * 
 * @author The LSST CCS Team
 */
public interface ImageSensitiveArea {
    
    /**
     * Expose the current object to the generated ImagePixelData.
     * This method is invoked to expose this ImageSensitiveArea to
     * ImagePixelData.
     * 
     * @param imagePixelData The ImagePixelData this ImageSensitiveArea is
     *                       exposed to.
     */
    public void exposeToImage(ImagePixelData imagePixelData);
    
    
    /**
     * Check if this object has data.
     * 
     * @return true if there is data.
     */
    public boolean hasPixelData();

    
    /**
     * Get the ImagePixelData for this object, if present. Null otherwise.
     * 
     * @return The latest accumulated ImagePixelData.
     */
    public ImagePixelData getImagePixelData();
}
