package org.lsst.ccs.utilities.ccd;

/**
 * An ITL CCD type.
 * This class contains the ITL constants as defined in LCA-13501.
 * 
 * @author The LSST CCS Team
 */
public class ITLCCDType extends CCDType{

    private final static SegmentGeometryConstants SEGMENTGEOMETRY_CONSTANTS = new SegmentGeometryConstants(2000,509,3);
    private final static CCDGeometryConstants CCD_GEOMETRY_CONSTANTS = new CCDGeometryConstants(SEGMENTGEOMETRY_CONSTANTS,99,63);

    /**
     * Create an ITL CCDType object.
     * 
     */
    public ITLCCDType() {    
        super("itl","3800C",CCD_GEOMETRY_CONSTANTS);
    }
    
}
