/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.gui.GuiHubService;
import org.astrogrid.samp.gui.MessageTrackerHubService;
import org.astrogrid.samp.gui.SysTray;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.xmlrpc.HubRunner;

public abstract class HubMode {
    private final String name_;
    private final boolean isDaemon_;
    private static final Logger logger_ = Logger.getLogger(HubMode.class.getName());
    public static final HubMode NO_GUI = HubMode.createBasicHubMode("no-gui");
    public static final HubMode CLIENT_GUI;
    public static HubMode MESSAGE_GUI;
    private static final HubMode[] KNOWN_MODES;

    HubMode(String name, boolean isDaemon) {
        this.name_ = name;
        this.isDaemon_ = isDaemon;
    }

    abstract HubService createHubService(Random var1, HubRunner[] var2);

    boolean isDaemon() {
        return this.isDaemon_;
    }

    String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static HubMode getModeFromName(String name) {
        HubMode[] modes = KNOWN_MODES;
        for (int im = 0; im < modes.length; ++im) {
            HubMode mode = modes[im];
            if (!mode.name_.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public static HubMode[] getAvailableModes() {
        ArrayList<HubMode> modeList = new ArrayList<HubMode>();
        for (int i = 0; i < KNOWN_MODES.length; ++i) {
            HubMode mode = KNOWN_MODES[i];
            if (mode instanceof BrokenHubMode) continue;
            modeList.add(mode);
        }
        return modeList.toArray(new HubMode[0]);
    }

    static void configureHubWindow(JFrame frame, HubRunner[] runners) {
        SysTray sysTray = SysTray.getInstance();
        if (sysTray.isSupported()) {
            try {
                HubMode.configureWindowForSysTray(frame, runners, sysTray);
            }
            catch (AWTException e) {
                logger_.warning("Failed to install in system tray: " + e);
                HubMode.configureWindowBasic(frame, runners);
            }
            logger_.info("Hub started in system tray");
        } else {
            logger_.info("System tray not supported: displaying hub window");
            HubMode.configureWindowBasic(frame, runners);
        }
    }

    private static void configureWindowBasic(JFrame frame, final HubRunner[] runners) {
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                HubRunner runner = runners[0];
                if (runner != null) {
                    runner.shutdown();
                }
            }
        });
        frame.setVisible(true);
    }

    private static void configureWindowForSysTray(final JFrame frame, final HubRunner[] runners, final SysTray sysTray) throws AWTException {
        final MenuItem showItem = new MenuItem("Show Hub Window");
        final MenuItem hideItem = new MenuItem("Hide Hub Window");
        final MenuItem stopItem = new MenuItem("Stop Hub");
        MenuItem[] items = new MenuItem[]{showItem, hideItem, stopItem};
        ActionListener iconListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frame.setVisible(true);
                showItem.setEnabled(false);
                hideItem.setEnabled(true);
            }
        };
        Image im = Toolkit.getDefaultToolkit().createImage(Client.class.getResource("images/hub.png"));
        String tooltip = "SAMP Hub";
        PopupMenu popup = new PopupMenu();
        final Object trayIcon = sysTray.addIcon(im, tooltip, popup, iconListener);
        ActionListener popListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String cmd = evt.getActionCommand();
                if (cmd.equals(showItem.getActionCommand()) || cmd.equals(hideItem.getActionCommand())) {
                    boolean visible = cmd.equals(showItem.getActionCommand());
                    frame.setVisible(visible);
                    showItem.setEnabled(!visible);
                    hideItem.setEnabled(visible);
                } else if (cmd.equals(stopItem.getActionCommand())) {
                    HubRunner runner = runners[0];
                    if (runner != null) {
                        runner.shutdown();
                    }
                    try {
                        sysTray.removeIcon(trayIcon);
                    }
                    catch (AWTException e) {
                        logger_.warning(e.toString());
                    }
                    frame.dispose();
                }
            }
        };
        for (int i = 0; i < items.length; ++i) {
            items[i].addActionListener(popListener);
            popup.add(items[i]);
        }
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                showItem.setEnabled(true);
                hideItem.setEnabled(false);
            }
        });
        popListener.actionPerformed(new ActionEvent(frame, 0, hideItem.getActionCommand()));
    }

    private static HubMode createBasicHubMode(String name) {
        try {
            return new HubMode(name, true){

                HubService createHubService(Random random, HubRunner[] runners) {
                    return new BasicHubService(random);
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubMode createGuiHubMode(String name) {
        try {
            GuiHubService.class.getName();
            return new HubMode(name, false){

                HubService createHubService(Random random, final HubRunner[] runners) {
                    return new GuiHubService(random){

                        public void start() {
                            super.start();
                            HubMode.configureHubWindow(this.createHubWindow(), runners);
                        }
                    };
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubMode createMessageTrackerHubMode(String name) {
        try {
            MessageTrackerHubService.class.getName();
            return new HubMode(name, false){

                HubService createHubService(Random random, final HubRunner[] runners) {
                    return new MessageTrackerHubService(random){

                        public void start() {
                            super.start();
                            HubMode.configureHubWindow(this.createHubWindow(), runners);
                        }
                    };
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    static {
        KNOWN_MODES = new HubMode[]{NO_GUI, CLIENT_GUI = HubMode.createGuiHubMode("client-gui"), MESSAGE_GUI = HubMode.createMessageTrackerHubMode("msg-gui")};
    }

    private static class BrokenHubMode
    extends HubMode {
        private final Throwable error_;

        BrokenHubMode(String name, Throwable error) {
            super(name, false);
            this.error_ = error;
        }

        HubService createHubService(Random random, HubRunner[] runners) {
            throw new RuntimeException("Hub mode " + this.getName() + " unavailable", this.error_);
        }
    }
}

