/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class HeaderSpecification {
    private String name;
    private final Map<String, HeaderLine> headers = new LinkedHashMap<String, HeaderLine>();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(?:(\\w+)\\.)?([\\w/]+)}");
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*(\\S+)\\s+(\\w+)\\s+(?:\"(.*)\"|(\\S+))\\s*(.*)");

    public HeaderSpecification(String name, InputStream in) throws IOException {
        this(name, new InputStreamReader(in));
    }

    public HeaderSpecification(String name, Reader in) throws IOException {
        this.name = name;
        this.loadHeaderSpecification(in);
    }

    final void loadHeaderSpecification(InputStream in) throws IOException {
        this.loadHeaderSpecification(new InputStreamReader(in));
    }

    final void loadHeaderSpecification(Reader in) throws IOException {
        String line;
        BufferedReader reader;
        BufferedReader bufferedReader = reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            try {
                HeaderLine headerLine = new HeaderLine(line);
                this.headers.put(headerLine.getKeyword(), headerLine);
            }
            catch (IOException x) {
                throw new IOException("Error while reading line:\n\t" + line, x);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public HeaderLine getHeader(String keyWord) {
        return this.headers.get(keyWord);
    }

    public Collection<HeaderLine> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    public static class HeaderLine {
        private final String keyword;
        private final DataType dataType;
        private final String comment;
        private final String metaName;
        private final Object value;
        private final String metaMap;
        private final boolean isExpression;

        private HeaderLine(String line) throws IOException {
            try {
                Matcher lineMatcher = LINE_PATTERN.matcher(line);
                if (!lineMatcher.matches()) {
                    throw new IOException("Invalid line in header specification");
                }
                this.keyword = lineMatcher.group(1);
                this.dataType = DataType.valueOf(lineMatcher.group(2));
                String valueExpression = lineMatcher.group(3) == null ? lineMatcher.group(4) : lineMatcher.group(3);
                Matcher matcher = EXPRESSION_PATTERN.matcher(valueExpression);
                this.isExpression = matcher.matches();
                if (this.isExpression) {
                    this.metaMap = matcher.group(1);
                    this.metaName = matcher.group(2);
                    this.value = null;
                } else {
                    this.metaMap = null;
                    this.metaName = null;
                    this.value = this.coerce(valueExpression, this.dataType);
                }
                this.comment = lineMatcher.group(5);
            }
            catch (IllegalArgumentException | FitsException x) {
                throw new IOException("Illegal token found while reading header specification", x);
            }
        }

        public String getKeyword() {
            return this.keyword;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getMetaName() {
            return this.metaName;
        }

        public String getComment() {
            return this.comment;
        }

        Object getValue(MetaDataSet metaDataSet) {
            if (this.isExpression) {
                return this.findMetaDataValue(this.metaMap, this.metaName, metaDataSet);
            }
            return this.value;
        }

        private Object findMetaDataValue(String map, String name, MetaDataSet metaDataSet) {
            return metaDataSet.getValue(map, name);
        }

        private Object coerce(String valueExpression, DataType dataType) throws FitsException, NumberFormatException {
            switch (dataType) {
                case Integer: {
                    return Integer.decode(valueExpression);
                }
                case Float: {
                    return Double.valueOf(valueExpression);
                }
                case Boolean: {
                    return Boolean.valueOf(valueExpression);
                }
                case Date: {
                    return DateUtils.convertStringToDate(valueExpression);
                }
                case MJD: {
                    return Double.valueOf(valueExpression);
                }
            }
            return valueExpression;
        }
    }

    public static enum DataType {
        Boolean,
        Integer,
        String,
        Float,
        Date,
        MJD;

    }
}

