/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.utilities;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FitsHeaderCardParser {
    private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("''");
    private static final Pattern KEYWORD_PATTERN = Pattern.compile("([A-Z|a-z|0-9|_|-]+)([ |\\.]*=?)");
    private static final Pattern STRING_PATTERN = Pattern.compile("'(?:[^']|'{2})*'");

    private static String deleteQuotes(String quotedString) {
        Matcher doubleQuoteMatcher = DOUBLE_QUOTE_PATTERN.matcher(quotedString);
        StringBuffer sb = new StringBuffer();
        if (doubleQuoteMatcher.find(1)) {
            do {
                doubleQuoteMatcher.appendReplacement(sb, "'");
            } while (doubleQuoteMatcher.find());
        }
        doubleQuoteMatcher.appendTail(sb);
        sb.deleteCharAt(0);
        sb.setLength(sb.length() - 1);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String extractComment(String stringCard, int startPosition) {
        int startOfComment = stringCard.indexOf(47, startPosition) + 1;
        if (startOfComment > 0 && stringCard.length() > startOfComment) {
            return stringCard.substring(startOfComment).trim();
        }
        return null;
    }

    public static String parseCardKey(String card) {
        int indexOfEquals = card.indexOf(61);
        StringBuilder builder = new StringBuilder();
        Matcher kewordMatcher = KEYWORD_PATTERN.matcher(card);
        while (kewordMatcher.find() && kewordMatcher.start() < indexOfEquals) {
            if (builder.length() != 0) {
                builder.append('.');
            }
            builder.append(kewordMatcher.group(1).toUpperCase(Locale.US));
            if (!kewordMatcher.group(2).endsWith("=")) continue;
            break;
        }
        return builder.toString();
    }

    public static ParsedValue parseCardValue(String card) {
        int indexOfEquals;
        ParsedValue value = FitsHeaderCardParser.parseStringValue(card);
        if (value == null && (indexOfEquals = card.indexOf(61)) > 0) {
            value = new ParsedValue();
            int endOfValue = card.length() - 1;
            int startOfComment = card.indexOf(47, indexOfEquals);
            if (startOfComment > 0) {
                endOfValue = startOfComment - 1;
                value.comment = FitsHeaderCardParser.extractComment(card, startOfComment);
            }
            value.value = card.substring(indexOfEquals + 1, endOfValue + 1).trim();
        }
        return value;
    }

    private static ParsedValue parseStringValue(String card) {
        ParsedValue stringValue = null;
        Matcher matcher = STRING_PATTERN.matcher(card);
        if (matcher.find()) {
            int indexOfComment = card.indexOf(47);
            if (indexOfComment >= 0 && indexOfComment < matcher.start()) {
                return null;
            }
            stringValue = new ParsedValue();
            stringValue.isString = true;
            stringValue.value = FitsHeaderCardParser.deleteQuotes(matcher.group(0));
            stringValue.comment = FitsHeaderCardParser.extractComment(card, matcher.end());
        }
        return stringValue;
    }

    private FitsHeaderCardParser() {
    }

    public static class ParsedValue {
        private String comment = null;
        private boolean isString = false;
        private String value = null;

        public String getComment() {
            return this.comment;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isString() {
            return this.isString;
        }
    }
}

