
package org.lsst.ccs.utilities.ccd;

/**
 * A utility class to display a Geometry tree.
 * This is just to visualize how the Geometries are arranged within a top
 * level geometry.
 * 
 * @author The LSST CCS Team.
 */
public class GeometryUtils {

    /**
     * Get a tree-like string representation of the full geometry tree for 
     * a given Geometry.
     * 
     * @param geometry The Geometry for which the tree is to be shown.
     * @return The String representation of the full geometry tree.
     */
    public static String showGeometryTree(Geometry geometry) {
        return showGeometryTree(geometry, -1);
    }

    /**
     * Get a tree-like string representation of the geometry tree for 
     * a given Geometry to a given depth.
     * 
     * @param geometry The Geometry for which the tree is to be shown.
     * @param depth    The depth at which the tree should stop. If negative
     *                 the full tree will be fetched.
     * @return The String representation of the geometry tree at the provided depth.
     */
    public static String showGeometryTree(Geometry geometry, int depth) {
        StringBuilder sb = new StringBuilder();
        printGeometryTree(geometry,depth, 0, sb);
        return sb.toString();
    }

    private static void printGeometryTree(Geometry geom, int depth, int level, StringBuilder sb) {
        if ( depth > 0 && level >= depth ) {
            return;
        }
        level++;
        String indent = "";
        for ( int i = 0; i < level; i++ ) {
            indent += "-";
        }
        sb.append(indent).append("-> ").append(geom.getUniqueId()).append("\n");
        if (geom.hasChildren()) {
            for ( int p = geom.getParallelChildrenCount() - 1; p>=0; p-- ) {
                for ( int s = 0; s<geom.getSerialChildrenCount(); s++ ) {
                    Geometry child = geom.getChild(p, s);
                    if ( child != null ) {
                        printGeometryTree(child, depth, level, sb);
                    }                    
                }
            }
        }
    }

}
