package org.lsst.ccs.utilities.image;

import org.lsst.ccs.utilities.ccd.CCD;

/**
 * Represents a set of images read from the DAQ. Each image typically contains
 * the data from a single amplifier, and is written to its own extended HDU in 
 * a fits file.
 * 
 * The ImageSet also contains information about the CCD type it was collected
 * from and the ReadOutParameters that were set on the sequencer when the
 * data was acquired.
 * 
 * @author tonyj
 */
public interface ImageSet {
    
    /**
     * Get the number of Images in the set.
     */
    default int getNumberOfImages() {
        return 16;
    }
    
    /**
     * Get the ID for this ImageSet.
     * This ID is used to access the FitsHeaderMetadataProvider that is used to
     * add additional meta-data when writing fits files.
     * 
     * @return the CCD for this ImageSet.
     */
    CCD getCCD();

    /**
     * Get the ReadOutParameters used to acquire this ImageSet.
     * 
     * @return The ImageSet ReadOutParameters
     */
    ReadOutParameters getReadOutParameters();
    
}
