/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.logging.Logger;

public final class ReadOutParameters {
    private int preRows;
    private int readRows;
    private int postRows;
    private int preCols;
    private int readCols;
    private int postCols;
    private int readCols2;
    private int overRows;
    private int overCols;
    private CCDType ccdType;
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.utilities.image.readoutparameters");

    public ReadOutParameters(CCDType ccdType, int preRows, int readRows, int postRows, int overRows, int preCols, int readCols, int postCols, int readCols2, int overCols) {
        this.preRows = preRows;
        this.readRows = readRows;
        this.postRows = postRows;
        this.overRows = overRows;
        this.preCols = preCols;
        this.readCols = readCols;
        this.postCols = postCols;
        this.overCols = overCols;
        this.readCols2 = readCols2;
        this.ccdType = ccdType;
        this.validate();
    }

    public ReadOutParameters(CCDType type) {
        this(type, 0, type.getCCDGeometryConstants().getSegmentParallelActiveSize(), 0, ReadOutParameters.getParallelOverscan(type), 0, type.getCCDGeometryConstants().getSegmentSerialPrescanSize() + type.getCCDGeometryConstants().getSegmentSerialActiveSize(), 0, 0, ReadOutParameters.getSerialOverscan(type));
        this.validate();
    }

    public int getPreRows() {
        return this.preRows;
    }

    public void setPreRows(int preRows) {
        this.preRows = preRows;
    }

    public int getReadRows() {
        return this.readRows;
    }

    public void setReadRows(int readRows) {
        this.readRows = readRows;
    }

    public int getPostRows() {
        return this.postRows;
    }

    public void setPostRows(int postRows) {
        this.postRows = postRows;
    }

    public int getPreCols() {
        return this.preCols;
    }

    public void setPreCols(int preCols) {
        this.preCols = preCols;
    }

    public int getReadCols() {
        return this.readCols;
    }

    public void setReadCols(int readCols) {
        this.readCols = readCols;
    }

    public int getPostCols() {
        return this.postCols;
    }

    public void setPostCols(int postCols) {
        this.postCols = postCols;
    }

    public int getReadCols2() {
        return this.readCols2;
    }

    public void setReadCols2(int readCols2) {
        this.readCols2 = readCols2;
    }

    public int getOverRows() {
        return this.overRows;
    }

    public void setOverRows(int overRows) {
        this.overRows = overRows;
    }

    public int getOverCols() {
        return this.overCols;
    }

    public void setOverCols(int overCols) {
        this.overCols = overCols;
    }

    public int getSerialReadPixels() {
        return this.getReadCols() + this.getReadCols2() + this.getOverCols();
    }

    public int getParallelReadPixels() {
        return this.getReadRows() + this.getOverRows();
    }

    public int getSerialRegister() {
        return this.getPreCols() + this.getReadCols() + this.getPostCols() + this.getReadCols2();
    }

    public int getSerialPrescan() {
        return this.ccdType.getCCDGeometryConstants().getSegmentSerialPrescanSize();
    }

    public int getTotalSerialSize() {
        return this.getSerialRegister() + this.getOverCols();
    }

    public int getTotalParallelSize() {
        return this.ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize() + this.getOverRows();
    }

    private static int getParallelOverscan(CCDType type) {
        if (type instanceof E2VCCDType) {
            return 46;
        }
        if (type instanceof ITLCCDType) {
            return 48;
        }
        return 0;
    }

    private static int getSerialOverscan(CCDType type) {
        if (type instanceof E2VCCDType) {
            return 22;
        }
        if (type instanceof ITLCCDType) {
            return 32;
        }
        return 0;
    }

    public static int getCCDTotalSerialSize(CCD ccd, ReadOutParameters readOutParameters) {
        return readOutParameters.getTotalSerialSize() * ccd.getSerialChildrenCount();
    }

    public static int getCCDTotalParallelSize(CCD ccd, ReadOutParameters readOutParameters) {
        return readOutParameters.getTotalParallelSize() * ccd.getParallelChildrenCount();
    }

    public void setCCDType(CCDType ccdType) {
        this.ccdType = ccdType;
    }

    private void validate() {
        boolean isValid = true;
        int totalParallelPixels = this.ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize();
        if (this.getPreRows() + this.getReadRows() + this.getPostRows() != totalParallelPixels) {
            log.warn((Object)("Parallel parameters are invalid: preRows(" + this.getPreRows() + ") + readRows(" + this.getReadRows() + ") + postRows(" + this.getPostRows() + ") != segRows(" + totalParallelPixels + ")"));
            isValid = false;
        }
        int totalSerialPixels = this.ccdType.getCCDGeometryConstants().getSegmentSerialActiveSize() + this.ccdType.getCCDGeometryConstants().getSegmentSerialPrescanSize();
        if (this.getPreCols() + this.getReadCols() + this.getPostCols() + this.getReadCols2() != totalSerialPixels) {
            log.warn((Object)("Serial parameters are invalid: preCols(" + this.getPreCols() + ") + readCols(" + this.getReadCols() + ") + readCols2(" + this.getReadCols2() + ") + postCols(" + this.getPostCols() + ") != serCols(" + totalSerialPixels + ")"));
            isValid = false;
        }
        if (!isValid) {
            log.warn((Object)"The geometry values in the Fits Headers will be incorrect.");
        }
    }
}

