/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class HeaderDescriptionTest {
    @Test
    public void testSpecFileRead() throws IOException {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        HeaderSpecification desc = (HeaderSpecification)headerSpecsBuilder.getHeaderSpecifications().get("primary");
        Collection headers = desc.getHeaders();
        Assert.assertEquals((long)35L, (long)headers.size());
        Assert.assertEquals((Object)"primary", (Object)desc.getName());
        HeaderSpecification.HeaderLine first = (HeaderSpecification.HeaderLine)headers.iterator().next();
        Assert.assertEquals((Object)HeaderSpecification.DataType.String, (Object)first.getDataType());
        Assert.assertEquals((Object)"ORIGIN", (Object)first.getKeyword());
        Assert.assertEquals((Object)5.52, (Object)desc.getHeader("CCDGAIN").getValue(null));
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("Origin", "Galaxy9");
        MetaDataSet metaDataSet = new MetaDataSet();
        metaDataSet.addMetaDataMap("primary", metaData);
        Assert.assertEquals((Object)"Galaxy9", (Object)first.getValue(metaDataSet));
    }

    @Test
    public void testHeaderLine() throws IOException {
        String lineTemplate = "TEST Float   %s   comments";
        HeaderSpecification.HeaderLine lineOldTrending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8/R00/Reb0/DigV}"));
        Assert.assertTrue((boolean)lineOldTrending.isWarning());
        Assert.assertEquals((Object)"ts8/R00/Reb0/DigV", (Object)lineOldTrending.getMetaName());
        Assert.assertNull((Object)lineOldTrending.getMetaMap());
        HeaderSpecification.HeaderLine lineNewTrending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8.R00/Reb0/DigV}"));
        Assert.assertTrue((!lineNewTrending.isWarning() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"R00/Reb0/DigV", (Object)lineNewTrending.getMetaName());
        Assert.assertEquals((Object)"ts8", (Object)lineNewTrending.getMetaMap());
        HeaderSpecification.HeaderLine lineOldTS8Trending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8/R00.Reb0.DigV}"));
        Assert.assertTrue((boolean)lineOldTS8Trending.isWarning());
        Assert.assertEquals((Object)"ts8/R00.Reb0.DigV", (Object)lineOldTS8Trending.getMetaName());
        Assert.assertNull((Object)lineOldTS8Trending.getMetaMap());
        HeaderSpecification.HeaderLine lineOldTS8TrendingWithDash = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8-a/R00.Reb0.DigV}"));
        Assert.assertTrue((boolean)lineOldTS8TrendingWithDash.isWarning());
        Assert.assertEquals((Object)"ts8-a/R00.Reb0.DigV", (Object)lineOldTS8TrendingWithDash.getMetaName());
        Assert.assertNull((Object)lineOldTS8TrendingWithDash.getMetaMap());
        HeaderSpecification.HeaderLine lineTemporaryTS8Trending = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8.R00.Reb0.DigV}"));
        Assert.assertTrue((!lineTemporaryTS8Trending.isWarning() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"R00.Reb0.DigV", (Object)lineTemporaryTS8Trending.getMetaName());
        Assert.assertEquals((Object)"ts8", (Object)lineTemporaryTS8Trending.getMetaMap());
        HeaderSpecification.HeaderLine lineTemporaryTS8TrendingWithDash = new HeaderSpecification.HeaderLine(String.format(lineTemplate, "${ts8-a.R00.Reb0.DigV}"));
        Assert.assertTrue((!lineTemporaryTS8TrendingWithDash.isWarning() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"R00.Reb0.DigV", (Object)lineTemporaryTS8TrendingWithDash.getMetaName());
        Assert.assertEquals((Object)"ts8-a", (Object)lineTemporaryTS8TrendingWithDash.getMetaMap());
    }
}

