package org.lsst.ccs.utilities.image;

import org.lsst.ccs.utilities.ccd.CCD;

/**
 * A default implementation of ImageSet.
 *
 * @author tonyj
 */
public class DefaultImageSet implements ImageSet {

    private final CCD ccd;
    private final ReadOutParameters readOutParameters;    

    public DefaultImageSet(CCD ccd, ReadOutParameters readOutParameters) {
        this.ccd = ccd;
        this.readOutParameters = readOutParameters;
    }

    @Override
    public ReadOutParameters getReadOutParameters() {
        return readOutParameters;
    }

    @Override
    public CCD getCCD() {
        return ccd;
    }

}
