/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nom.tam.util.Cursor;
import nom.tam.util.CursorValue;

public class HashedList<KEY, VALUE extends CursorValue<KEY>>
implements Collection<VALUE> {
    private final ArrayList<VALUE> ordered = new ArrayList();
    private final HashMap<KEY, VALUE> keyed = new HashMap();

    private void add(int pos, VALUE reference) {
        VALUE entry = reference;
        Object key = entry.getKey();
        if (this.keyed.containsKey(key) && !this.unkeyedKey(key)) {
            int oldPos = this.indexOf(entry);
            if (oldPos == -1) {
                "".toString();
            }
            this.keyed.remove(key);
            this.ordered.remove(oldPos);
            if (oldPos < pos) {
                --pos;
            }
        }
        this.keyed.put(key, entry);
        if (pos >= this.ordered.size()) {
            this.ordered.add(entry);
        } else {
            this.ordered.add(pos, entry);
        }
    }

    private boolean unkeyedKey(KEY key) {
        return "COMMENT".equals(key) || "HISTORY".equals(key);
    }

    @Override
    public boolean add(VALUE e) {
        this.add(this.ordered.size(), e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends VALUE> c) {
        for (CursorValue element : c) {
            this.add((VALUE)element);
        }
        return true;
    }

    @Override
    public void clear() {
        this.keyed.clear();
        this.ordered.clear();
    }

    @Override
    public boolean contains(Object o) {
        for (CursorValue entry : this.ordered) {
            if (!o.equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ArrayList values = new ArrayList(c);
        for (CursorValue entry : this.ordered) {
            values.remove(entry);
        }
        return values.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.keyed.containsKey(key);
    }

    public VALUE get(int n) {
        return (VALUE)((CursorValue)this.ordered.get(n));
    }

    public Object get(Object key) {
        CursorValue entry = (CursorValue)this.keyed.get(key);
        return entry == null ? null : entry;
    }

    private int indexOf(VALUE entry) {
        for (int index = 0; index < this.ordered.size(); ++index) {
            Object searchKEy = entry.getKey();
            if (!searchKEy.equals(((CursorValue)this.ordered.get(index)).getKey())) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.ordered.isEmpty();
    }

    @Override
    public Iterator<VALUE> iterator() {
        return new HashedListIterator(0);
    }

    public Cursor<KEY, VALUE> iterator(int n) {
        if (n >= 0 && n <= this.ordered.size()) {
            return new HashedListIterator(n);
        }
        throw new NoSuchElementException("Invalid index for iterator:" + n);
    }

    public HashedListIterator iterator(KEY key) {
        CursorValue entry = (CursorValue)this.keyed.get(key);
        if (entry != null) {
            return new HashedListIterator(this.indexOf(entry));
        }
        throw new NoSuchElementException("Unknown key for iterator:" + key);
    }

    public boolean remove(int index) {
        if (index >= 0 && index < this.ordered.size()) {
            CursorValue entry = (CursorValue)this.ordered.get(index);
            this.keyed.remove(entry.getKey());
            this.ordered.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        for (int i = 0; i < this.ordered.size(); ++i) {
            CursorValue entry = (CursorValue)this.ordered.get(i);
            if (!o.equals(entry)) continue;
            return this.remove(i);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object element : c.toArray()) {
            result |= this.remove(element);
        }
        return result;
    }

    public boolean removeKey(Object key) {
        CursorValue entry = (CursorValue)this.keyed.get(key);
        if (entry != null) {
            int index = this.indexOf(entry);
            this.keyed.remove(key);
            this.ordered.remove(index);
            return true;
        }
        return false;
    }

    public boolean replaceKey(KEY oldKey, KEY newKey) {
        if (!this.keyed.containsKey(oldKey) || this.keyed.containsKey(newKey)) {
            return false;
        }
        CursorValue oldVal = (CursorValue)this.keyed.get(oldKey);
        this.keyed.remove(oldKey);
        this.keyed.put(newKey, oldVal);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<VALUE> iter = this.iterator();
        boolean result = false;
        while (iter.hasNext()) {
            VALUE o = iter.next();
            if (c.contains(o)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        return this.ordered.size();
    }

    public void sort(Comparator<KEY> comp) {
        Collections.sort(this.ordered, new EntryComparator(comp));
    }

    @Override
    public Object[] toArray() {
        Object[] o = new Object[this.ordered.size()];
        return this.toArray(o);
    }

    @Override
    public <T> T[] toArray(T[] o) {
        if (o.length < this.size()) {
            o = (Object[])Array.newInstance(o.getClass().getComponentType(), this.size());
        }
        for (int index = 0; index < o.length; ++index) {
            o[index] = this.ordered.get(index);
        }
        return o;
    }

    public String toString() {
        return this.ordered.toString();
    }

    private class HashedListIterator
    implements Cursor<KEY, VALUE> {
        private int current;

        HashedListIterator(int start) {
            this.current = start;
        }

        @Override
        public void add(KEY key, VALUE ref) {
            this.add((VALUE)ref);
        }

        @Override
        public void add(VALUE reference) {
            HashedList.this.add(this.current++, reference);
        }

        @Override
        public VALUE end() {
            this.current = Math.max(0, HashedList.this.ordered.size() - 1);
            return this.next();
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0 && this.current < HashedList.this.ordered.size();
        }

        @Override
        public boolean hasPrev() {
            return this.current > 0;
        }

        @Override
        public VALUE next() {
            if (this.current < 0 || this.current >= HashedList.this.ordered.size()) {
                throw new NoSuchElementException("Outside list");
            }
            CursorValue entry = (CursorValue)HashedList.this.ordered.get(this.current);
            ++this.current;
            return entry;
        }

        @Override
        public VALUE next(int count) {
            for (int index = 1; index < count; ++index) {
                this.next();
            }
            return this.next();
        }

        @Override
        public VALUE prev() {
            if (this.current <= 0) {
                throw new NoSuchElementException("Before beginning of list");
            }
            --this.current;
            CursorValue entry = (CursorValue)HashedList.this.ordered.get(this.current);
            return entry;
        }

        @Override
        public void remove() {
            if (this.current > 0 && this.current <= HashedList.this.ordered.size()) {
                HashedList.this.remove(this.current - 1);
                if (this.current > 0) {
                    --this.current;
                }
            }
        }

        @Override
        public void setKey(KEY key) {
            CursorValue entry = (CursorValue)HashedList.this.keyed.get(key);
            this.current = entry != null ? HashedList.this.indexOf(entry) : HashedList.this.ordered.size();
        }
    }

    private static final class EntryComparator<KEY, VALUE extends CursorValue<KEY>>
    implements Comparator<VALUE> {
        private final Comparator<KEY> comp;

        private EntryComparator(Comparator<KEY> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(VALUE o1, VALUE o2) {
            return this.comp.compare(o1.getKey(), o2.getKey());
        }
    }
}

