/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class CCDDemo {
    public static void main(String[] args) throws InterruptedException, IOException, FitsException {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        headerSpecsBuilder.addSpecFile("test_cond");
        E2VCCDType type = new E2VCCDType();
        CCD ccd = CCD.createCCD((CCDType)type);
        CCDDemo.writeFitsFile(ccd, headerSpecsBuilder);
        type = new ITLCCDType();
        ccd = CCD.createCCD((CCDType)type);
        CCDDemo.writeFitsFile(ccd, headerSpecsBuilder);
    }

    private static void writeFitsFile(CCD ccd, FitsHeadersSpecificationsBuilder headerSpecsBuilder) throws InterruptedException, IOException, FitsException {
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)ccd, (String)"ripples", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)ccd, (GeneratedImage)generatedImage);
        String raftName = String.format(ccd.getType().getName() + "S%d%d", 0, 0);
        File raftFile = new File("/tmp/" + raftName + ".fits");
        Map primaryHeaders = FitsHeaderUtilities.getCCDPrimaryHeaders((CCD)ccd);
        primaryHeaders.put("Raft", primaryHeaders);
        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCD)ccd);
        FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet, headerSpecsBuilder.getHeaderSpecifications());
        for (Segment segment : ccd.getSegments()) {
            ffw.write(segment.getChannel() - 1, segment.getRawImageData(imageSet.getReadOutParameters()).getImageData());
        }
    }
}

