/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.comp.plio;

import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class PLIOCompress {
    private static final int FIRST_VALUE_WITH_13_BIT = 4096;
    private static final int FIRST_VALUE_WITH_14_BIT = 8192;
    private static final int FIRST_VALUE_WITH_15_BIT = 16384;
    private static final int FIRST_VALUE_WITH_16_BIT = 32768;
    private static final int HEADER_SIZE_FIELD1 = 3;
    private static final int HEADER_SIZE_FIELD2 = 4;
    private static final int LAST_VALUE_FITTING_IN_12_BIT = 4095;
    private static final int MINI_HEADER_SIZE = 3;
    private static final int MINI_HEADER_SIZE_FIELD = 2;
    private static final int N20481 = 20481;
    private static final int OPCODE_1 = 1;
    private static final int OPCODE_2 = 2;
    private static final int OPCODE_3 = 3;
    private static final int OPCODE_4 = 4;
    private static final int OPCODE_5 = 5;
    private static final int OPCODE_6 = 6;
    private static final int OPCODE_7 = 7;
    private static final int OPCODE_8 = 8;
    private static final short[] PLIO_HEADER = new short[]{0, 7, -100, 0, 0, 0, 0};
    private static final int SHIFT_12_BITS = 12;
    private static final int SHIFT_15_BITS = 15;
    private static final int VALUE_OF_BIT_13_AND14_ON = 12288;

    public void compress(IntBuffer pixelData, ShortBuffer compressedData, int npix) {
        compressedData.position(0);
        compressedData.put(PLIO_HEADER);
        int xe = npix - 1;
        int op = PLIO_HEADER.length;
        int pv = Math.max(0, pixelData.get(0));
        int x1 = 0;
        int iz = 0;
        int hi = 1;
        int nv = 0;
        for (int ip = 0; ip <= xe; ++ip) {
            int dv;
            if (ip < xe) {
                nv = Math.max(0, pixelData.get(ip + 1));
                if (nv == pv) continue;
                if (pv == 0) {
                    pv = nv;
                    x1 = ip + 1;
                    continue;
                }
            } else if (pv == 0) {
                x1 = xe + 1;
            }
            int np = ip - x1 + 1;
            int nz = x1 - iz;
            boolean skip = false;
            if (pv > 0 && (dv = pv - hi) != 0) {
                hi = pv;
                if (Math.abs(dv) > 4095) {
                    compressedData.put(op, (short)((pv & 0xFFF) + 4096));
                    compressedData.put(++op, (short)(pv / 4096));
                    ++op;
                } else {
                    if (dv < 0) {
                        compressedData.put(op, (short)(-dv + 12288));
                    } else {
                        compressedData.put(op, (short)(dv + 8192));
                    }
                    ++op;
                    if (np == 1 && nz == 0) {
                        short v = compressedData.get(op - 1);
                        compressedData.put(op - 1, (short)(v | 0x4000));
                        skip = true;
                    }
                }
            }
            if (!skip && nz > 0) {
                while (nz > 0) {
                    compressedData.put(op, (short)Math.min(4095, nz));
                    ++op;
                    nz -= 4095;
                }
                if (np == 1 && pv > 0) {
                    compressedData.put(op - 1, (short)(compressedData.get(op - 1) + 20481));
                    skip = true;
                }
            }
            if (!skip) {
                while (np > 0) {
                    compressedData.put(op, (short)(Math.min(4095, np) + 16384));
                    ++op;
                    np -= 4095;
                }
            }
            iz = x1 = ip + 1;
            pv = nv;
        }
        compressedData.put(3, (short)(op % 32768));
        compressedData.put(4, (short)(op / 32768));
        compressedData.position(op);
    }

    public void decompress(ShortBuffer compressedData, IntBuffer pixelData, int npix) {
        int llfirt;
        int lllen;
        if (compressedData.get(2) <= 0) {
            lllen = (compressedData.get(4) << 15) + compressedData.get(3);
            llfirt = compressedData.get(1);
        } else {
            lllen = compressedData.get(2);
            llfirt = 3;
        }
        int xe = npix - 1;
        int op = 0;
        int x1 = 1;
        int pv = 1;
        for (int ip = llfirt; ip <= lllen; ++ip) {
            int opcode = compressedData.get(ip) / 4096;
            int data = compressedData.get(ip) & 0xFFF;
            int sw0001 = opcode + 1;
            if (sw0001 == 1 || sw0001 == 5 || sw0001 == 6) {
                int x2 = x1 + data - 1;
                int i2 = Math.min(x2, xe);
                int np = i2 - Math.max(x1, 0) + 1;
                if (np > 0) {
                    int index;
                    int otop = op + np - 1;
                    if (opcode != 4) {
                        for (index = op; index <= otop; ++index) {
                            pixelData.put(index, 0);
                        }
                        if (opcode == 5 && i2 == x2) {
                            pixelData.put(otop, pv);
                        }
                    } else {
                        for (index = op; index <= otop; ++index) {
                            pixelData.put(index, pv);
                        }
                    }
                    op = otop + 1;
                }
                x1 = x2 + 1;
            } else if (sw0001 == 2) {
                pv = (compressedData.get(ip + 1) << 12) + data;
                ++ip;
            } else if (sw0001 == 3) {
                pv += data;
            } else if (sw0001 == 4) {
                pv -= data;
            } else if (sw0001 == 7) {
                pv += data;
                if (x1 >= 0 && x1 <= xe) {
                    pixelData.put(op, pv);
                    ++op;
                }
                ++x1;
            } else if (sw0001 == 8) {
                pv -= data;
                if (x1 >= 0 && x1 <= xe) {
                    pixelData.put(op, pv);
                    ++op;
                }
                ++x1;
            }
            if (x1 > xe) break;
        }
        for (int index = op; index < npix; ++index) {
            pixelData.put(index, 0);
        }
        pixelData.position(npix);
    }
}

