/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;

public class CCDTypeUtils {
    public static <T extends Geometry> T changeCCDTypeForGeometry(T geometry, CCDType newType) {
        Object newGeometry = CCDTypeUtils.createNewGeometryForCCDType(geometry, newType);
        if (newGeometry instanceof CCD) {
            return (T)newGeometry;
        }
        for (int p = 0; p < geometry.getParallelChildrenCount(); ++p) {
            for (int s = 0; s < geometry.getSerialChildrenCount(); ++s) {
                Object child = geometry.getChild(p, s);
                if (child == null) continue;
                ((Geometry)newGeometry).addChildGeometry(CCDTypeUtils.changeCCDTypeForGeometry(child, newType), p, s);
            }
        }
        return (T)newGeometry;
    }

    private static <T extends Geometry> T createNewGeometryForCCDType(T geometry, CCDType newType) {
        if (geometry instanceof CCD) {
            return (T)CCD.createCCD(newType);
        }
        if (geometry instanceof Reb) {
            return (T)new Reb(newType);
        }
        if (geometry instanceof Raft) {
            return (T)new Raft(newType);
        }
        if (geometry instanceof FocalPlane) {
            return geometry;
        }
        throw new IllegalArgumentException("Cannot create new Geometry for " + geometry);
    }
}

