/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;
import org.lsst.ccs.utilities.ccd.Reb;

public class Raft
extends Geometry<Reb> {
    private final RaftGeometryConstants raftConstants;

    public Raft(CCDType type) {
        this(RaftGeometryConstants.createRaftGeometryConstants(type));
    }

    Raft(RaftGeometryConstants raftConstants) {
        super("R", new Dimension(raftConstants.getRaftx(), raftConstants.getRafty()), 3, 1);
        this.raftConstants = raftConstants;
    }

    @Override
    protected void addGeometryToGrid(Reb child, int p, int s) {
        if (s != 0) {
            throw new IllegalArgumentException("Rafts can only accept Reb children in the parallel direction.");
        }
        int xCoord = (2 - p) * child.getWidth() + (2 - p) * this.raftConstants.getGap_inx() + (int)this.raftConstants.getGap_outx();
        this.addGeometry(child, xCoord, (int)this.raftConstants.getGap_outy());
    }

    public RaftGeometryConstants getRaftGeometryConstants() {
        return this.raftConstants;
    }

    public void addReb(Reb reb, int rebId) {
        this.addChildGeometry(reb, rebId, 0);
    }

    public static Raft createRaft(CCDType type) {
        Raft raft = new Raft(type);
        for (int i = 2; i >= 0; --i) {
            Reb reb = Reb.createReb(type);
            raft.addReb(reb, i);
        }
        return raft;
    }
}

