/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.FutureTask;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class TestRaftsFitsWriting {
    private static final String fitsFileName = "/tmp/R99_S%d%d";

    @Test
    public void testRaftsFitsFileWriting() throws IOException, FitsException, InterruptedException {
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
        E2VCCDType type = new E2VCCDType();
        Raft raft = Raft.createRaft((CCDType)type);
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)raft, (String)"ripples", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)raft, (GeneratedImage)generatedImage);
        TestRaftsFitsWriting.writeFitsFilesForRaft(raft, true);
        TestRaftsFitsWriting.writeFitsFilesForRaft(raft, false);
        for (int rebId = 0; rebId < raft.getParallelChildrenCount(); ++rebId) {
            for (int ccdId = 0; ccdId < 3; ++ccdId) {
                String raftName = String.format(fitsFileName, rebId, ccdId);
                String parallelRaftName = raftName + "_parallel";
                File raftFile = new File(raftName + ".fits");
                File parallelRaftFile = new File(parallelRaftName + ".fits");
                Fits serialFits = new Fits(raftFile);
                Fits parallelFits = new Fits(parallelRaftFile);
                serialFits.read();
                parallelFits.read();
                Assert.assertEquals((long)serialFits.getNumberOfHDUs(), (long)parallelFits.getNumberOfHDUs());
                for (int i = 0; i < serialFits.getNumberOfHDUs(); ++i) {
                    BasicHDU serialHdu = serialFits.getHDU(i);
                    BasicHDU parallelHdu = parallelFits.getHDU(i);
                    Assert.assertEquals((long)serialHdu.getData().getSize(), (long)parallelHdu.getData().getSize());
                    Object serialData = serialHdu.getData().getData();
                    Object parallelData = parallelHdu.getData().getData();
                    if (serialData == null) {
                        Assert.assertNull((Object)parallelData);
                    } else if (serialData instanceof ColumnTable) {
                        ColumnTable serialTable = (ColumnTable)serialData;
                        ColumnTable parallelTable = (ColumnTable)parallelData;
                        Assert.assertEquals((long)serialTable.getNCols(), (long)parallelTable.getNCols());
                        Assert.assertEquals((long)serialTable.getNRows(), (long)parallelTable.getNRows());
                        Assert.assertArrayEquals((int[])serialTable.getSizes(), (int[])parallelTable.getSizes());
                    } else if (serialData instanceof int[][]) {
                        int[][] serialDataArray = (int[][])serialData;
                        int[][] parallelDataArray = (int[][])parallelData;
                        int size = serialDataArray.length;
                        Assert.assertEquals((long)serialDataArray.length, (long)parallelDataArray.length);
                        for (int j = 0; j < size; ++j) {
                            Assert.assertArrayEquals((int[])serialDataArray[j], (int[])parallelDataArray[j]);
                        }
                    }
                    Header serialHeader = serialHdu.getHeader();
                    Header parallelHeader = parallelHdu.getHeader();
                    Assert.assertEquals((long)serialHeader.getNumberOfCards(), (long)parallelHeader.getNumberOfCards());
                    Cursor serialIter = serialHeader.iterator();
                    Cursor parallelIter = parallelHeader.iterator();
                    while (serialIter.hasNext()) {
                        HeaderCard serialCard = (HeaderCard)serialIter.next();
                        HeaderCard parallelCard = (HeaderCard)parallelIter.next();
                        Assert.assertEquals((Object)serialCard.getKey(), (Object)parallelCard.getKey());
                        Assert.assertEquals((Object)serialCard.getValue(), (Object)parallelCard.getValue());
                        Assert.assertEquals((Object)serialCard.getComment(), (Object)parallelCard.getComment());
                    }
                }
                Assert.assertEquals((long)raftFile.length(), (long)parallelRaftFile.length());
            }
        }
    }

    private static void writeFitsFilesForRaft(Raft raft, boolean inParallel) throws IOException, FitsException, InterruptedException {
        String how = inParallel ? "in parallel" : "sequentially";
        System.out.print("Writing out fits files " + how);
        long start = System.currentTimeMillis();
        Thread[] ts = new Thread[raft.getParallelChildrenCount() * 3];
        for (int rebId = 0; rebId < raft.getParallelChildrenCount(); ++rebId) {
            Reb reb = (Reb)raft.getChild(rebId, 0);
            for (int ccdId = 0; ccdId < 3; ++ccdId) {
                File raftFile;
                CCD ccd = (CCD)reb.getChild(0, ccdId);
                String raftName = String.format(fitsFileName, rebId, ccdId);
                if (inParallel) {
                    raftName = raftName + "_parallel";
                }
                if ((raftFile = new File(raftName + ".fits")).exists()) {
                    raftFile.delete();
                }
                ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD((CCD)ccd);
                FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet);
                if (inParallel) {
                    Thread t;
                    ts[rebId * 3 + ccdId] = t = new Thread(new FitsFileWriterRunnable(ffw, ccd.getSegments(), imageSet.getReadOutParameters()));
                    t.start();
                    continue;
                }
                for (Segment segment : ccd.getSegments()) {
                    ffw.write(segment.getChannel() - 1, segment.getRawImageData(imageSet.getReadOutParameters()).getImageData());
                }
            }
        }
        if (inParallel) {
            for (Thread t : ts) {
                t.join();
            }
        }
        double totalTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println(" took " + totalTime + " seconds");
    }

    private static class FitsFileWriterRunnable
    implements Runnable {
        private final FitsFileWriter ffw;
        private final List<Segment> segments;
        private final ReadOutParameters readOutParameters;

        FitsFileWriterRunnable(FitsFileWriter ffw, List<Segment> segments, ReadOutParameters readOutParameters) {
            this.ffw = ffw;
            this.segments = segments;
            this.readOutParameters = readOutParameters;
        }

        @Override
        public void run() {
            try {
                FutureTask[] segmentThreads = new FutureTask[this.segments.size()];
                for (Segment segment : this.segments) {
                    segmentThreads[segment.getChannel() - 1] = this.ffw.asyncWrite(segment.getChannel() - 1, segment.getRawImageData(this.readOutParameters).getImageData());
                }
                for (Segment segment : this.segments) {
                    segmentThreads[segment.getChannel() - 1].get();
                }
            }
            catch (Exception ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

