package org.lsst.ccs.utilities.image;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Segment;

/**
 * An implementation of FitsHeaderMetadataProvider based on a Geometry object.
 * It internally creates CCD level FitsHeaderMetadataProvider objects that will
 * be used when fits files are written.
 * 
 * This is achieve by holding a reference to the Geometry object for which the
 * fits files are being written. The CCD information is extracted using the
 * ImageSet.getImageSetId() method that should return the unique CCD id  within
 * the provided geometry.
 *
 * @author The LSST CCS Team
 */
class GeometryFitsHeaderMetadataProvider implements FitsHeaderMetadataProvider {

    @Override
    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        MetaDataSet primaryHeaderMetadata = new MetaDataSet();
        primaryHeaderMetadata.addMetaDataMap("imageSet", FitsHeaderUtilities.getCCDPrimaryHeaders(imageSet.getCCD()));
        return primaryHeaderMetadata;
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        MetaDataSet extendedHeaderMetadata = new MetaDataSet();
        CCD ccd = imageSet.getCCD();
        Segment segment = ccd.getSegments().get(extendedIndex);
        extendedHeaderMetadata.addMetaDataMap("channel",FitsHeaderUtilities.getSegmentHeaders(segment, imageSet.getReadOutParameters()));
        return extendedHeaderMetadata;        
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        return null;
    }
    
}
