package org.lsst.ccs.utilities.image;

import java.util.ArrayList;
import java.util.List;

/**
 * An implementation of FitsHeaderMetadataProvider that allows multiple providers
 * to be added to it. It is responsible to combining the resulting maps.
 *
 * @author The LSST CCS Team
 */
class CompositeFitsHeaderMetadataProvider implements FitsHeaderMetadataProvider {

    private final List<FitsHeaderMetadataProvider> providers = new ArrayList<>();
    private static final Object LOCK = new Object();

    
    void addFitsHeaderMetadataProvider(FitsHeaderMetadataProvider provider) {
        synchronized(LOCK) {
            providers.add(provider);
        }
    }

    void removeFitsHeaderMetadataProvider(FitsHeaderMetadataProvider provider) {
        synchronized(LOCK) {
            providers.remove(provider);
        }
    }
    
    @Override
    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        synchronized(LOCK) {
            MetaDataSet resultingHeaderMetadata = new MetaDataSet();
            for ( FitsHeaderMetadataProvider provider : providers ) {
                resultingHeaderMetadata.addMetaDataSet(provider.getPrimaryHeaderMetadata(imageSet));
            }
            return resultingHeaderMetadata;
        }
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        synchronized(LOCK) {
            MetaDataSet resultingHeaderMetadata = new MetaDataSet();
            for ( FitsHeaderMetadataProvider provider : providers ) {
                resultingHeaderMetadata.addMetaDataSet(provider.getDataExtendedHeaderMetadata(imageSet,extendedIndex));
            }
            return resultingHeaderMetadata;
        }
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        synchronized(LOCK) {
            MetaDataSet resultingHeaderMetadata = new MetaDataSet();
            for ( FitsHeaderMetadataProvider provider : providers ) {
                resultingHeaderMetadata.addMetaDataSet(provider.getAdditionalExtendedHeaderMetadata(imageSet,extendedKeyword));
            }
            return resultingHeaderMetadata;
        }
    }

    @Override
    public void completedHeaderMetadata(ImageSet imageSet) {
        synchronized(LOCK) {
            for ( FitsHeaderMetadataProvider provider : providers ) {
                provider.completedHeaderMetadata(imageSet);
            }
        }
    }
    
    
    
}
