package org.lsst.ccs.utilities.ccd.image.data;

/**
 * A Listener for RawImageData.
 * Will be notified when the RawImageData is available.
 * 
 * @author turri
 */
public interface RawImageDataListener {
    
    /**
     * Call-back method when data is available for the RawImageDataProvider.
     * 
     * @param imageDataProvider The RawImageDataProvider for which the data is available.
     * 
     */
    void rawImageDataAvailable(RawImageDataProvider imageDataProvider);
    
}
