package org.lsst.ccs.utilities.ccd;

/**
 * A class that defines the type of a CCD.
 * A CCDType is defined by:
 *  - A name
 *  - The CCD geometry constants as defined in CCDGeometryConstants
 * 
 * Two subclasses are provided: E2VCCDType and ITLCCDType. Other instances
 * can be created when needed by a test-stand or testing environment by 
 * extending this class.
 * 
 * @author The LSST CCS Team
 */
public class CCDType {

    private final CCDGeometryConstants ccdGeometryConstants;
    private final String name;
    
    /**
     * Create a CCDType.
     * 
     * @param name The name of this CCDType
     * @param ccdGeometryConstants The geometry constants for this CCD.
     */
    protected CCDType(String name, CCDGeometryConstants ccdGeometryConstants) {                
        this.ccdGeometryConstants = ccdGeometryConstants;
        this.name = name;
    }
    
    /**
     * Get the CCDGeometryConstants for this CCDType.
     * 
     * @return The CCD geometry constants for this type of CCD.
     */
    public CCDGeometryConstants getCCDGeometryConstants() {
        return ccdGeometryConstants;
    }
    
    /**
     * The name of this CCDType.
     * 
     * @return The name for this type of CCD.
     */
    public String getName() {
        return name;
    }
    
}


