/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.SegmentGeometryConstants;

public final class CCDGeometryConstants {
    private final double parallelEdge;
    private final double serialEdge;
    private final SegmentGeometryConstants segmentGeometryConstants;
    public static final int SEGMENTS_ALONG_SERIAL = 8;
    public static final int SEGMENTS_ALONG_PARALLEL = 2;

    public CCDGeometryConstants(SegmentGeometryConstants segmentGeometryConstants, double parallelEdge, double serialEdge) {
        this.segmentGeometryConstants = segmentGeometryConstants;
        this.parallelEdge = parallelEdge;
        this.serialEdge = serialEdge;
    }

    SegmentGeometryConstants getSegmentGeometryConstraint() {
        return this.segmentGeometryConstants;
    }

    public int getSegmentParallelActiveSize() {
        return this.segmentGeometryConstants.getSegmentParallelActiveSize();
    }

    public int getSegmentSerialActiveSize() {
        return this.segmentGeometryConstants.getSegmentSerialActiveSize();
    }

    public int getActiveAreaParallelSize() {
        return this.getSegmentParallelActiveSize() * 2;
    }

    public int getActiveAreaSerialSize() {
        return this.getSegmentSerialActiveSize() * 8;
    }

    public int getPhysicalAreaParallelSize() {
        return this.getActiveAreaParallelSize() + (int)(2.0 * this.parallelEdge);
    }

    public int getPhysicalAreaSerialSize() {
        return this.getActiveAreaSerialSize() + (int)(2.0 * this.serialEdge);
    }

    double getParallelEdge() {
        return this.parallelEdge;
    }

    double getSerialEdge() {
        return this.serialEdge;
    }
}

