/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.image.DefaultFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProviderFactory;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.ImageSet;

public class GeometryFitsHeaderMetadataProviderFactory
implements FitsHeaderMetadataProviderFactory {
    private final Geometry geometry;
    private final Map<String, FitsHeaderMetadataProvider> providerMap = new HashMap<String, FitsHeaderMetadataProvider>();

    public GeometryFitsHeaderMetadataProviderFactory(Geometry geom) {
        this.geometry = geom;
        this.introspectGeometry(this.geometry);
    }

    @Override
    public FitsHeaderMetadataProvider createFitsHeaderMetadataProvider(ImageSet imageSet) {
        return this.providerMap.get(imageSet.getImageSetId());
    }

    private void introspectGeometry(Geometry<?> geom) {
        if (geom instanceof CCD) {
            this.createMetadataProvider((CCD)geom);
        } else {
            for (Geometry g : geom.getChildrenList()) {
                this.introspectGeometry(g);
            }
        }
    }

    private void createMetadataProvider(CCD ccd) {
        ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD(ccd);
        DefaultFitsHeaderMetadataProvider provider = new DefaultFitsHeaderMetadataProvider(imageSet);
        this.providerMap.put(ccd.getUniqueId(), provider);
    }
}

