/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsHeaderUtilities {
    private static String pair(String a, String b) {
        return "[" + a + "," + b + "]";
    }

    private static String range(int a, int b) {
        return a + ":" + b;
    }

    private static String range(int a, int b, boolean flip) {
        return flip ? FitsHeaderUtilities.range(b, a) : FitsHeaderUtilities.range(a, b);
    }

    public static ImageSet createImageSetForCCD(CCDInterface ccd) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.putAll(FitsHeaderUtilities.getCCDPrimaryHeaders(ccd));
        DefaultImageSet imageSet = new DefaultImageSet(metaData);
        for (SegmentInterface segment : ccd.getSegments()) {
            MetaDataSet metaDataSet = new MetaDataSet();
            Map<String, Object> imageMetaData = FitsHeaderUtilities.getSegmentHeaders(segment);
            metaDataSet.addMetaData("channel", imageMetaData);
            imageSet.addImage(ccd.getType().getSegmentTotalSerialSize(), ccd.getType().getSegmentTotalParallelSize(), metaDataSet);
        }
        return imageSet;
    }

    private static Geometry<?> findParentOfType(Geometry<?> geom, Class clazz) {
        Geometry parent = geom.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getClass().isAssignableFrom(clazz)) {
            return parent;
        }
        return FitsHeaderUtilities.findParentOfType(parent, clazz);
    }

    public static Map<String, Object> getCCDPrimaryHeaders(CCDInterface ccd) {
        HashMap<String, Object> primaryMetaData = new HashMap<String, Object>();
        return primaryMetaData;
    }

    public static Map<String, Object> getSegmentHeaders(SegmentInterface segment) {
        HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
        imageMetaData.put("EXTNAME", String.format("Segment%01d%01d", FitsHeaderUtilities.getSegmentParallelPosition(segment), FitsHeaderUtilities.getSegmentSerialPosition(segment)));
        imageMetaData.put("CHANNEL", segment.getChannel());
        imageMetaData.put("CCDSUM", "1 1");
        CCDType type = segment.getCCDType();
        imageMetaData.put("DTM1_1", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("DTM2_2", -1.0 * FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("DTV1", FitsHeaderUtilities.getDTV1(segment));
        imageMetaData.put("DTV2", FitsHeaderUtilities.getDTV2(segment));
        imageMetaData.put("DETSIZE", FitsHeaderUtilities.pair(FitsHeaderUtilities.range(1, 8 * type.getDimh()), FitsHeaderUtilities.range(1, 2 * type.getDimv())));
        imageMetaData.put("DATASEC", FitsHeaderUtilities.pair(FitsHeaderUtilities.range(1 + type.getPreh(), type.getPreh() + type.getDimh()), FitsHeaderUtilities.range(1, type.getDimv())));
        imageMetaData.put("DETSEC", FitsHeaderUtilities.getDETSEC(segment));
        imageMetaData.put("PC1_2A", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1A", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_2C", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1C", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_2R", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1R", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_2F", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC2_1F", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC1_1B", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC2_2B", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("PC1_1Q", segment.getCCDType().equals((Object)CCDType.E2V) ? FitsHeaderUtilities.getOneMinusTwoSx(segment) : -1.0);
        imageMetaData.put("PC2_2Q", FitsHeaderUtilities.getOneMinusTwoSx(segment));
        imageMetaData.put("CRVAL1A", FitsHeaderUtilities.getCRVAL1A(segment));
        imageMetaData.put("CRVAL2A", FitsHeaderUtilities.getCRVAL2A(segment));
        imageMetaData.put("CRVAL1C", FitsHeaderUtilities.getCRVAL1C(segment));
        imageMetaData.put("CRVAL2C", FitsHeaderUtilities.getCRVAL2C(segment));
        imageMetaData.put("CRVAL1B", FitsHeaderUtilities.getCRVAL2C(segment));
        imageMetaData.put("CRVAL2B", FitsHeaderUtilities.getCRVAL1C(segment));
        CCD ccd = null;
        if (segment instanceof Geometry) {
            ccd = (CCD)FitsHeaderUtilities.findParentOfType((Geometry)((Object)segment), CCD.class);
        }
        if (ccd != null) {
            imageMetaData.put("CRVAL1R", FitsHeaderUtilities.getCRVAL1R(segment, ccd));
            imageMetaData.put("CRVAL2R", FitsHeaderUtilities.getCRVAL2R(segment, ccd));
            imageMetaData.put("CRVAL1Q", FitsHeaderUtilities.getCRVAL2R(segment, ccd));
            imageMetaData.put("CRVAL2Q", FitsHeaderUtilities.getCRVAL1R(segment, ccd));
            Raft raft = (Raft)FitsHeaderUtilities.findParentOfType(ccd, Raft.class);
            if (raft != null) {
                imageMetaData.put("CRVAL1F", FitsHeaderUtilities.getCRVAL1F(segment, ccd, raft));
                imageMetaData.put("CRVAL2F", FitsHeaderUtilities.getCRVAL2F(segment, ccd, raft));
            }
        }
        return imageMetaData;
    }

    private static int getSegmentParallelPosition(SegmentInterface seg) {
        return seg.getParallelPosition();
    }

    private static int getSegmentSerialPosition(SegmentInterface seg) {
        return seg.getSerialPosition();
    }

    private static boolean isReadoutDown(SegmentInterface seg) {
        return seg.isReadoutDown();
    }

    private static boolean isReadoutLeft(SegmentInterface seg) {
        return seg.isReadoutLeft();
    }

    private static double getOneMinusTwoSx(SegmentInterface seg) {
        return 1 - 2 * seg.getParallelPosition();
    }

    private static double getCRVAL1A(SegmentInterface seg) {
        return seg.getParallelPosition() * (seg.getCCDType().getDimv() + 1);
    }

    private static double getCRVAL2A(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        double sx = seg.getParallelPosition();
        if (type.equals((Object)CCDType.E2V)) {
            return sx * (double)(type.getDimh() + 1) + (2.0 * sx - 1.0) * (double)type.getPreh();
        }
        return type.getDimh() + 1 - type.getPreh();
    }

    private static double getCRVAL1C(SegmentInterface seg) {
        return seg.getParallelPosition() * (2 * seg.getCCDType().getDimv() + 1);
    }

    private static double getCRVAL2C(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        double sy = seg.getSerialPosition();
        return FitsHeaderUtilities.getCRVAL2A(seg) + sy * (double)type.getDimh();
    }

    private static double getCRVAL1R(SegmentInterface seg, CCDInterface ccd) {
        CCDType type = seg.getCCDType();
        return FitsHeaderUtilities.getCRVAL1C(seg) + type.getGap_outx() + 0.5 * (double)(type.getCCDpx() - type.getCCDax()) + (double)(((Geometry)((Object)ccd)).getParallelPosition() * (2 * type.getDimv() + type.getGap_inx() + type.getCCDpx() - type.getCCDax()));
    }

    private static double getCRVAL2R(SegmentInterface seg, CCDInterface ccd) {
        CCDType type = seg.getCCDType();
        return FitsHeaderUtilities.getCRVAL2C(seg) + type.getGap_outy() + 0.5 * (double)(type.getCCDpy() - type.getCCDay()) + (double)(((Geometry)((Object)ccd)).getSerialPosition() * (8 * type.getDimh() + type.getGap_iny() + type.getCCDpy() - type.getCCDay()));
    }

    private static double getCRVAL1F(SegmentInterface seg, CCDInterface ccd, Raft raft) {
        CCDType type = seg.getCCDType();
        return FitsHeaderUtilities.getCRVAL1R(seg, ccd) + (double)(raft.getParallelPosition() * type.getRaftx());
    }

    private static double getCRVAL2F(SegmentInterface seg, CCDInterface ccd, Raft raft) {
        CCDType type = seg.getCCDType();
        return FitsHeaderUtilities.getCRVAL2R(seg, ccd) + (double)(raft.getSerialPosition() * type.getRafty());
    }

    private static int getDTV1(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        int sx = type.equals((Object)CCDType.E2V) ? seg.getParallelPosition() : 1;
        return (type.getDimh() + 1 + 2 * type.getPreh()) * sx + seg.getSerialPosition() * type.getDimh() - type.getPreh();
    }

    private static int getDTV2(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        return (1 - seg.getParallelPosition()) * (2 * type.getDimv() + 1);
    }

    private static int getDSX1(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        int sx = seg.getParallelPosition();
        int sy = seg.getSerialPosition();
        if (type.equals((Object)CCDType.E2V)) {
            int res = (sy + 1) * type.getDimh() * sx;
            return res + (sy * type.getDimh() + 1) * (1 - sx);
        }
        return (sy + 1) * type.getDimh();
    }

    private static int getDSX2(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        int sx = seg.getParallelPosition();
        int sy = seg.getSerialPosition();
        if (type.equals((Object)CCDType.E2V)) {
            int res = (sy * type.getDimh() + 1) * sx;
            return res + (sy + 1) * type.getDimh() * (1 - sx);
        }
        return sy * type.getDimh() + 1;
    }

    private static int getDSY1(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        int sx = seg.getParallelPosition();
        return 2 * type.getDimv() * (1 - sx) + sx;
    }

    private static int getDSY2(SegmentInterface seg) {
        CCDType type = seg.getCCDType();
        int sx = seg.getParallelPosition();
        return (type.getDimv() + 1) * (1 - sx) + type.getDimv() * sx;
    }

    private static String getDETSEC(SegmentInterface segment) {
        return FitsHeaderUtilities.pair(FitsHeaderUtilities.range(FitsHeaderUtilities.getDSX1(segment), FitsHeaderUtilities.getDSX2(segment)), FitsHeaderUtilities.range(FitsHeaderUtilities.getDSY1(segment), FitsHeaderUtilities.getDSY2(segment)));
    }
}

