/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDGeometry;

public enum CCDType {
    E2V(10, 2002, 512, 22, 46, true, 96.5, 52.0, 28, 25, 26.5, 25.0),
    ITL(3, 2000, 509, 32, 48, false, 99.0, 63.0, 27, 27, 26.0, 26.0);

    private CCDGeometry ccdGeom;
    private static final int SEGMENTS_ALONG_SERIAL = 8;
    private static final int SEGMENTS_ALONG_PARALLEL = 2;
    private final int serialActiveSize;
    private final int parallelActiveSize;
    private final int serialPrescanSize;
    private final int serialOverscanSize;
    private final int parallelOverscanSize;
    private final double parallelEdge;
    private final double serialEdge;
    private final int gap_inx;
    private final int gap_iny;
    private final double gap_outx;
    private final double gap_outy;

    private CCDType(int prescan, int segmentWidth, int segmentHeight, int overscan, int parallelOverscan, boolean isE2V, double parallelEdge, double serialEdge, int gap_inx, int gap_iny, double gap_outx, double gap_outy) {
        int i;
        this.serialActiveSize = segmentHeight;
        this.parallelActiveSize = segmentWidth;
        this.serialPrescanSize = prescan;
        this.serialOverscanSize = overscan;
        this.parallelOverscanSize = parallelOverscan;
        this.parallelEdge = parallelEdge;
        this.serialEdge = serialEdge;
        this.gap_inx = gap_inx;
        this.gap_iny = gap_iny;
        this.gap_outx = gap_outx;
        this.gap_outy = gap_outy;
        this.ccdGeom = new CCDGeometry(8, 2, segmentHeight, segmentWidth, prescan, overscan, parallelOverscan, this);
        for (i = 0; i < 8; ++i) {
            this.ccdGeom.addSegment(i + 1, i, 1, CCDGeometry.ReadoutOrder.UpLeft);
        }
        for (i = 8; i < 16; ++i) {
            this.ccdGeom.addSegment(i + 1, 15 - i, 0, isE2V ? CCDGeometry.ReadoutOrder.DownRight : CCDGeometry.ReadoutOrder.UpRight);
        }
    }

    public int getSegmentParallelActiveSize() {
        return this.getDimv();
    }

    public int getDimv() {
        return this.parallelActiveSize;
    }

    public int getSegmentSerialActiveSize() {
        return this.getDimh();
    }

    public int getDimh() {
        return this.serialActiveSize;
    }

    public int getActiveAreaParallelSize() {
        return this.getCCDax();
    }

    public int getCCDax() {
        return this.getDimv() * 2;
    }

    public int getActiveAreaSerialSize() {
        return this.getCCDay();
    }

    public int getCCDay() {
        return this.getDimh() * 8;
    }

    public int getPhysicalAreaParallelSize() {
        return this.getCCDpx();
    }

    public int getCCDpx() {
        return this.getCCDax() + (int)(2.0 * this.parallelEdge);
    }

    public int getPhysicalAreaSerialSize() {
        return this.getCCDpy();
    }

    public int getCCDpy() {
        return this.getCCDay() + (int)(2.0 * this.serialEdge);
    }

    public double getParallelEdge() {
        return this.parallelEdge;
    }

    public double getSerialEdge() {
        return this.serialEdge;
    }

    public int getGap_inx() {
        return this.gap_inx;
    }

    public int getGap_iny() {
        return this.gap_iny;
    }

    public double getGap_outx() {
        return this.gap_outx;
    }

    public double getGap_outy() {
        return this.gap_outy;
    }

    public int getRaftx() {
        return 3 * this.getCCDpx() + 2 * this.getGap_inx() + (int)(2.0 * this.getGap_outx());
    }

    public int getRafty() {
        return 3 * this.getCCDpy() + 2 * this.getGap_iny() + (int)(2.0 * this.getGap_outy());
    }

    public int getSegmentTotalSerialSize() {
        return this.getSegmentSerialActiveSize() + this.getSegmentSerialOverscanSize() + this.getSegmentSerialPrescanSize();
    }

    public int getSegmentSerialPrescanSize() {
        return this.serialPrescanSize;
    }

    public int getPreh() {
        return this.getSegmentSerialPrescanSize();
    }

    public int getSegmentSerialOverscanSize() {
        return this.serialOverscanSize;
    }

    public int getOverh() {
        return this.getSegmentSerialOverscanSize();
    }

    public int getSegmentTotalParallelSize() {
        return this.getSegmentParallelActiveSize() + this.getSegmentParallelOverscanSize();
    }

    public int getSegmentParallelOverscanSize() {
        return this.parallelOverscanSize;
    }

    public int getOverv() {
        return this.getSegmentParallelOverscanSize();
    }

    public CCDGeometry getGeometry() {
        return this.ccdGeom;
    }
}

