/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.data;

import java.awt.Point;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

@RunWith(value=Parameterized.class)
public class RawDataTest {
    private final CCDType type;

    @Parameterized.Parameters(name="{0}")
    public static List<CCDType> getProductionTypes() {
        ArrayList<CCDType> res = new ArrayList<CCDType>();
        res.add(CCDType.E2V);
        res.add(CCDType.ITL);
        return res;
    }

    public RawDataTest(CCDType type) {
        this.type = type;
    }

    @Test
    public void testCCDRawData() throws ParseException {
        CCD ccd = CCD.createCCD((String)"C00", (CCDType)this.type);
        int width = ccd.getWidth();
        int height = ccd.getHeight();
        int[][] data = new int[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                data[i][j] = i + j;
            }
        }
        GeneratedImage generatedImage = new GeneratedImage(data, (double)width);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)ccd, (GeneratedImage)generatedImage);
        TestCase.assertEquals((int)ccd.getWidth(), (int)generatedImage.getWidth());
        TestCase.assertEquals((int)ccd.getHeight(), (int)generatedImage.getHeight());
        for (SegmentInterface seg : ccd.getSegments()) {
            int i;
            boolean increase_y;
            Segment s = (Segment)seg;
            ByteBuffer rawData = s.getRawImageData().getImageData();
            Point origin = s.getAbsolutePoint(new Point(0, 0));
            int x = origin.x;
            int y = origin.y;
            int start_x = x;
            boolean increase_x = true;
            if (!s.isReadoutLeft()) {
                increase_x = false;
                start_x += s.getWidth() - 1;
            }
            int start_y = y;
            boolean bl = increase_y = !s.isReadoutDown();
            if (s.isReadoutDown()) {
                start_y += s.getHeight() - 1;
            }
            for (i = 0; i < s.getSegmentParallelActiveSize(); ++i) {
                int j;
                int value_y = start_y;
                for (j = 0; j < s.getSegmentSerialPrescanSize(); ++j) {
                    Assert.assertEquals((long)0L, (long)rawData.getInt());
                }
                for (j = 0; j < s.getSegmentSerialActiveSize(); ++j) {
                    Assert.assertEquals((long)(value_y + start_x), (long)rawData.getInt());
                    value_y += increase_y ? 1 : -1;
                }
                for (j = 0; j < s.getSegmentSerialOverscanSize(); ++j) {
                    Assert.assertEquals((long)0L, (long)rawData.getInt());
                }
                start_x += increase_x ? 1 : -1;
            }
            for (i = 0; i < s.getSegmentParallelOverscanSize(); ++i) {
                for (int j = 0; j < s.getSegmentTotalSerialSize(); ++j) {
                    Assert.assertEquals((long)0L, (long)rawData.getInt());
                }
            }
            Assert.assertFalse((boolean)rawData.hasRemaining());
        }
    }

    @Test
    public void testRebRawData() throws ParseException {
        Raft raftGeometry = Raft.createRaft((String)"R00", (CCDType)this.type);
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry((Geometry)raftGeometry, (String)"image", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage((Geometry)raftGeometry, (GeneratedImage)generatedImage);
        TestCase.assertEquals((int)raftGeometry.getWidth(), (int)generatedImage.getWidth());
        TestCase.assertEquals((int)raftGeometry.getHeight(), (int)generatedImage.getHeight());
        for (Reb reb : raftGeometry.getChildrenList()) {
            ByteBuffer rawData = reb.getRawImageData().getImageData();
            CCD ccd = (CCD)reb.getChild(0, 0);
            int ccdSize = ccd.getTotalParallelSize() * ccd.getTotalSerialSize();
            TestCase.assertEquals((int)rawData.capacity(), (int)(ccdSize * 3 * 4));
            for (int i = 0; i < rawData.capacity() / 4; ++i) {
                rawData.getInt();
            }
        }
    }
}

