/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsCheckSumTest;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriterTest {
    private final Random random = new Random(12345L);
    private static final List<String> primaryHeaderContent = new ArrayList<String>();

    @Before
    public void prepareTests() {
        FitsHeadersSpecifications.addSpecFile((String)"primary");
        FitsHeadersSpecifications.addSpecFile((String)"extended");
        FitsHeadersSpecifications.addSpecFile((String)"test_cond");
    }

    @After
    public void cleanUpTests() {
        FitsHeadersSpecifications.removeAllHeaderSpecifications();
    }

    @Test
    public void testWrite() throws Exception {
        Date obs = new Date();
        Map<String, Object> metaDataSet = FitsFileWriterTest.generateMetaData(obs);
        File tmp = File.createTempFile("img", "fits");
        tmp.deleteOnExit();
        int width = 256;
        int height = 256;
        DefaultImageSet imageSet = new DefaultImageSet(metaDataSet);
        imageSet.addImage(width, height, null);
        for (int i = 0; i < 1000; ++i) {
            try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet);){
                writer.write(0, this.generateFakeImageData(width, height));
            }
            FitsCheckSumTest.testCheckSum(tmp);
            var9_9 = null;
            try (Fits fits = new Fits(tmp);){
                fits.read();
                BasicHDU primary = fits.getHDU(0);
                Assert.assertEquals((Object)obs, (Object)primary.getObservationDate());
                Assert.assertEquals((double)DateUtils.convertDateToMJD((Date)obs), (double)((Double)primary.getHeader().findCard("MJD-OBS").getValue(Double.class, (Object)0.0)), (double)0.0);
                Assert.assertEquals((long)3L, (long)fits.getNumberOfHDUs());
                continue;
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }
    }

    private void checkPrimaryHeader(BasicHDU primaryHeader) {
        Assert.assertEquals((long)primaryHeaderContent.size(), (long)((HeaderSpecification)FitsHeadersSpecifications.getHeaderSpecifications().get("primary")).getHeaders().size());
        HeaderSpecification primaryHeaderSpec = (HeaderSpecification)FitsHeadersSpecifications.getHeaderSpecifications().get("primary");
        Cursor iter = primaryHeader.getHeader().iterator();
        while (iter.hasNext()) {
            System.out.println(((HeaderCard)iter.next()).getKey());
        }
        for (String keyword : primaryHeaderContent) {
            System.out.println("Checking key " + keyword);
            Assert.assertTrue((boolean)primaryHeader.getHeader().containsKey(keyword));
            Assert.assertTrue((primaryHeaderSpec.getHeader(keyword) != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteNaN() throws ParseException, IOException, FitsException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.mm.dd hh:mm z");
        Date obs = sdf.parse("2015.09.15 14:11 UTC");
        Map<String, Object> metaDataSet = FitsFileWriterTest.generateMetaData(obs);
        metaDataSet.put("ExposureTime", Float.valueOf(Float.NaN));
        File tmp = File.createTempFile("img", "fits");
        tmp.deleteOnExit();
        int width = 256;
        int height = 256;
        DefaultImageSet imageSet = new DefaultImageSet(metaDataSet);
        imageSet.addImage(width, height, null);
        try (FitsFileWriter writer = new FitsFileWriter(tmp, (ImageSet)imageSet);){
            writer.write(0, this.generateFakeImageData(width, height));
            TestCase.fail((String)"We should never get here");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private ByteBuffer generateFakeImageData(int imageWidth, int imageHeight) {
        int length = 4 * imageWidth * imageHeight;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer data = buffer.asIntBuffer();
        while (data.hasRemaining()) {
            data.put(this.random.nextInt(65536) - 32768);
        }
        return buffer;
    }

    public static Map<String, Object> generateMetaData(Date obs) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("Origin", "Galaxy9");
        metaData.put("SequenceNumber", 12);
        metaData.put("ExposureTime", 15);
        metaData.put("ObservationDate", obs);
        return metaData;
    }

    static {
        primaryHeaderContent.add("ORIGIN");
        primaryHeaderContent.add("DATE");
        primaryHeaderContent.add("DATE-OBS");
        primaryHeaderContent.add("MJD-OBS");
        primaryHeaderContent.add("IMAGETAG");
        primaryHeaderContent.add("TSTAND");
        primaryHeaderContent.add("INSTRUME");
        primaryHeaderContent.add("CONTROLL");
        primaryHeaderContent.add("CONTNUM");
        primaryHeaderContent.add("CCD_MANU");
        primaryHeaderContent.add("CCD_TYPE");
        primaryHeaderContent.add("CCD_SERN");
        primaryHeaderContent.add("LSST_NUM");
        primaryHeaderContent.add("TESTTYPE");
        primaryHeaderContent.add("IMGTYPE");
        primaryHeaderContent.add("SEQNUM");
        primaryHeaderContent.add("TEMP_SET");
        primaryHeaderContent.add("CCDTEMP");
        primaryHeaderContent.add("MONDIOD");
        primaryHeaderContent.add("MONOWL");
        primaryHeaderContent.add("FILTER");
        primaryHeaderContent.add("EXPTIME");
        primaryHeaderContent.add("SHUT_DEL");
        primaryHeaderContent.add("CTRLCFG");
        primaryHeaderContent.add("FILENAME");
        primaryHeaderContent.add("DETSIZE");
        primaryHeaderContent.add("BINX");
        primaryHeaderContent.add("BINY");
        primaryHeaderContent.add("HEADVER");
        primaryHeaderContent.add("CCDGAIN");
        primaryHeaderContent.add("CCDNOISE");
    }
}

