/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.Iterator;
import junit.framework.TestCase;
import org.junit.Test;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.SegmentInterface;

public class TestCompareCCDs {
    @Test
    public void testE2V() {
        this.compareCCDType(CCDType.E2V);
        this.compareCCDType(CCDType.ITL);
    }

    private void compareCCDType(CCDType ccdType) {
        CCDGeometry ccd1 = ccdType.getGeometry();
        CCD ccd2 = CCD.createCCD((String)"sensor00", (CCDType)ccdType);
        TestCase.assertEquals((int)ccd1.getSerialSegmentCount(), (int)ccd2.getSerialSegmentCount());
        TestCase.assertEquals((int)ccd1.getParallelSegmentCount(), (int)ccd2.getParallelSegmentCount());
        for (int s = 0; s < ccd1.getSerialSegmentCount(); ++s) {
            for (int p = 0; p < ccd1.getParallelSegmentCount(); ++p) {
                SegmentInterface seg1 = ccd1.getSegment(p, s);
                SegmentInterface seg2 = ccd2.getSegment(p, s);
                this.compareSegments(seg1, seg2);
            }
        }
        int count = 1;
        Iterator segments2 = ccd2.getSegments().iterator();
        for (SegmentInterface seg1 : ccd1.getSegments()) {
            SegmentInterface seg2 = (SegmentInterface)segments2.next();
            this.compareSegments(seg1, seg2);
            TestCase.assertEquals((int)seg1.getChannel(), (int)count++);
        }
    }

    private void compareSegments(SegmentInterface seg1, SegmentInterface seg2) {
        TestCase.assertEquals((int)seg1.getChannel(), (int)seg2.getChannel());
        TestCase.assertEquals((int)seg1.getSegmentParallelActiveSize(), (int)seg2.getSegmentParallelActiveSize());
        TestCase.assertEquals((int)seg1.getSegmentSerialActiveSize(), (int)seg2.getSegmentSerialActiveSize());
        TestCase.assertEquals((int)seg1.getSegmentTotalParallelSize(), (int)seg2.getSegmentTotalParallelSize());
        TestCase.assertEquals((int)seg1.getParallelPosition(), (int)seg2.getParallelPosition());
        TestCase.assertEquals((int)seg1.getSerialPosition(), (int)seg2.getSerialPosition());
        TestCase.assertEquals((boolean)seg1.isReadoutDown(), (boolean)seg2.isReadoutDown());
        TestCase.assertEquals((boolean)seg1.isReadoutLeft(), (boolean)seg2.isReadoutLeft());
    }
}

