/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;

@RunWith(value=Parameterized.class)
public class DimensionsTest {
    private final CCDType type;

    @Parameterized.Parameters(name="{0}")
    public static List<CCDType> getProductionTypes() {
        ArrayList<CCDType> res = new ArrayList<CCDType>();
        res.add(CCDType.E2V);
        res.add(CCDType.ITL);
        return res;
    }

    public DimensionsTest(CCDType type) {
        this.type = type;
    }

    @Test
    public void testRaftDimensions() {
        Raft r = Raft.createRaft((String)"R", (CCDType)this.type);
        Assert.assertEquals((long)r.getType().getRaftx(), (long)r.getDimension().width);
        Assert.assertEquals((long)r.getType().getRafty(), (long)r.getDimension().height);
    }

    @Test
    public void testCCDDimensions() {
        CCD c = CCD.createCCD((String)"C", (CCDType)this.type);
        Assert.assertEquals((long)c.getType().getCCDpx(), (long)c.getDimension().width);
        Assert.assertEquals((long)c.getType().getCCDpy(), (long)c.getDimension().height);
    }

    @Test
    public void testRebDimensions() {
        Reb reb = Reb.createReb((String)"reb", (int)0, (CCDType)this.type);
        Assert.assertEquals((long)(reb.getType().getRafty() - (int)(2.0 * reb.getType().getGap_outy())), (long)reb.getDimension().height);
        Assert.assertEquals((long)reb.getType().getCCDpx(), (long)reb.getDimension().width);
    }
}

