/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.geometry.Geometry;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.CCDTransform;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;

public class CCDTypeTest {
    private static int e2vTests;
    private static int itlTests;
    private final String[] itlDETSEC = new String[]{"[509:1,1:2000]", "[1018:510,1:2000]", "[1527:1019,1:2000]", "[2036:1528,1:2000]", "[2545:2037,1:2000]", "[3054:2546,1:2000]", "[3563:3055,1:2000]", "[4072:3564,1:2000]", "[4072:3564,4000:2001]", "[3563:3055,4000:2001]", "[3054:2546,4000:2001]", "[2545:2037,4000:2001]", "[2036:1528,4000:2001]", "[1527:1019,4000:2001]", "[1018:510,4000:2001]", "[509:1,4000:2001]"};
    private final int[] itlDTV1 = new int[]{510, 1019, 1528, 2037, 2546, 3055, 3564, 4073, 4073, 3564, 3055, 2546, 2037, 1528, 1019, 510};
    private final int[] itlDTV2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 4001, 4001, 4001, 4001, 4001, 4001, 4001, 4001};
    private final double[] itlDTM1_1 = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] itlDTM2_2 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] itlCRVAL1A = new double[]{2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 2001.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] itlCRVAL2A = new double[]{507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0, 507.0};
    private final double[] itlPC1_2A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] itlCRVAL1C = new double[]{4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 4001.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] itlCRVAL2C = new double[]{507.0, 1016.0, 1525.0, 2034.0, 2543.0, 3052.0, 3561.0, 4070.0, 4070.0, 3561.0, 3052.0, 2543.0, 2034.0, 1525.0, 1016.0, 507.0};
    private final double[] itlPC1_2C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[][] itlCRVAL1R = new double[][]{{4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0}, {8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0}, {12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0}};
    private final double[][] itlCRVAL2R = new double[][]{{596.0, 1105.0, 1614.0, 2123.0, 2632.0, 3141.0, 3650.0, 4159.0, 4159.0, 3650.0, 3141.0, 2632.0, 2123.0, 1614.0, 1105.0, 596.0}, {4821.0, 5330.0, 5839.0, 6348.0, 6857.0, 7366.0, 7875.0, 8384.0, 8384.0, 7875.0, 7366.0, 6857.0, 6348.0, 5839.0, 5330.0, 4821.0}, {9046.0, 9555.0, 10064.0, 10573.0, 11082.0, 11591.0, 12100.0, 12609.0, 12609.0, 12100.0, 11591.0, 11082.0, 10573.0, 10064.0, 9555.0, 9046.0}};
    private final double[] itlPC1_2R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[][] itlCRVAL1F = new double[][]{{4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 4126.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0, 125.0}, {8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 8351.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0, 4350.0}, {12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 12576.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0, 8575.0}};
    private final double[][] itlCRVAL2F = new double[][]{{596.0, 1105.0, 1614.0, 2123.0, 2632.0, 3141.0, 3650.0, 4159.0, 4159.0, 3650.0, 3141.0, 2632.0, 2123.0, 1614.0, 1105.0, 596.0}, {4821.0, 5330.0, 5839.0, 6348.0, 6857.0, 7366.0, 7875.0, 8384.0, 8384.0, 7875.0, 7366.0, 6857.0, 6348.0, 5839.0, 5330.0, 4821.0}, {9046.0, 9555.0, 10064.0, 10573.0, 11082.0, 11591.0, 12100.0, 12609.0, 12609.0, 12100.0, 11591.0, 11082.0, 10573.0, 10064.0, 9555.0, 9046.0}};
    private final double[] itlPC1_2F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itlPC2_1F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final String[] e2vDETSEC = new String[]{"[512:1,1:2002]", "[1024:513,1:2002]", "[1536:1025,1:2002]", "[2048:1537,1:2002]", "[2560:2049,1:2002]", "[3072:2561,1:2002]", "[3584:3073,1:2002]", "[4096:3585,1:2002]", "[3585:4096,4004:2003]", "[3073:3584,4004:2003]", "[2561:3072,4004:2003]", "[2049:2560,4004:2003]", "[1537:2048,4004:2003]", "[1025:1536,4004:2003]", "[513:1024,4004:2003]", "[1:512,4004:2003]"};
    private final int[] e2vDTV1 = new int[]{523, 1035, 1547, 2059, 2571, 3083, 3595, 4107, 3574, 3062, 2550, 2038, 1526, 1014, 502, -10};
    private final int[] e2vDTV2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 4005, 4005, 4005, 4005, 4005, 4005, 4005, 4005};
    private final double[] e2vDTM1_1 = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vDTM2_2 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private final double[] e2vCRVAL1A = new double[]{2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 2003.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] e2vCRVAL2A = new double[]{523.0, 523.0, 523.0, 523.0, 523.0, 523.0, 523.0, 523.0, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0, -10.0};
    private final double[] e2vPC1_2A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1A = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vCRVAL1C = new double[]{4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 4005.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] e2vCRVAL2C = new double[]{523.0, 1035.0, 1547.0, 2059.0, 2571.0, 3083.0, 3595.0, 4107.0, 3574.0, 3062.0, 2550.0, 2038.0, 1526.0, 1014.0, 502.0, -10.0};
    private final double[] e2vPC1_2C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1C = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[][] e2vCRVAL1R = new double[][]{{4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0}, {8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0}, {12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0}};
    private final double[][] e2vCRVAL2R = new double[][]{{600.0, 1112.0, 1624.0, 2136.0, 2648.0, 3160.0, 3672.0, 4184.0, 3651.0, 3139.0, 2627.0, 2115.0, 1603.0, 1091.0, 579.0, 67.0}, {4825.0, 5337.0, 5849.0, 6361.0, 6873.0, 7385.0, 7897.0, 8409.0, 7876.0, 7364.0, 6852.0, 6340.0, 5828.0, 5316.0, 4804.0, 4292.0}, {9050.0, 9562.0, 10074.0, 10586.0, 11098.0, 11610.0, 12122.0, 12634.0, 12101.0, 11589.0, 11077.0, 10565.0, 10053.0, 9541.0, 9029.0, 8517.0}};
    private final double[] e2vPC1_2R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1R = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[][] e2vCRVAL1F = new double[][]{{4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 4128.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0, 123.0}, {8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 8353.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0, 4348.0}, {12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 12578.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0, 8573.0}};
    private final double[][] e2vCRVAL2F = new double[][]{{600.0, 1112.0, 1624.0, 2136.0, 2648.0, 3160.0, 3672.0, 4184.0, 3651.0, 3139.0, 2627.0, 2115.0, 1603.0, 1091.0, 579.0, 67.0}, {4825.0, 5337.0, 5849.0, 6361.0, 6873.0, 7385.0, 7897.0, 8409.0, 7876.0, 7364.0, 6852.0, 6340.0, 5828.0, 5316.0, 4804.0, 4292.0}, {9050.0, 9562.0, 10074.0, 10586.0, 11098.0, 11610.0, 12122.0, 12634.0, 12101.0, 11589.0, 11077.0, 10565.0, 10053.0, 9541.0, 9029.0, 8517.0}};
    private final double[] e2vPC1_2F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] e2vPC2_1F = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};

    @Test
    public void testE2V() {
        CCDType type = CCDType.E2V;
        CCDGeometry geometry = type.getGeometry();
        this.testE2VInterface((CCDInterface)geometry, 0, 0, 0, 0, false);
    }

    @Test
    public void testE2VNew() {
        FocalPlane fp = new FocalPlane();
        CCDType type = CCDType.E2V;
        Raft raft00 = Raft.createRaft((String)"R00", (CCDType)type);
        fp.addChildGeometry((Geometry)raft00, 0, 0);
        Raft raft21 = Raft.createRaft((String)"R21", (CCDType)type);
        fp.addChildGeometry((Geometry)raft21, 2, 1);
        for (Raft raft : fp.getChildrenList()) {
            for (int p = 0; p < raft.getParallelChildrenCount(); ++p) {
                Reb reb = (Reb)raft.getChild(p, 0);
                for (int s = 0; s < reb.getSerialChildrenCount(); ++s) {
                    this.testE2VInterface((CCDInterface)reb.getChild(0, s), p, s, raft.getParallelPosition(), raft.getSerialPosition(), true);
                }
            }
        }
    }

    @Test
    public void testE2VDimensions() {
        CCDType ccd = CCDType.E2V;
        Assert.assertEquals((long)2002L, (long)ccd.getSegmentParallelActiveSize());
        Assert.assertEquals((long)512L, (long)ccd.getSegmentSerialActiveSize());
        Assert.assertEquals((long)4004L, (long)ccd.getActiveAreaParallelSize());
        Assert.assertEquals((long)4096L, (long)ccd.getActiveAreaSerialSize());
        Assert.assertEquals((long)4197L, (long)ccd.getPhysicalAreaParallelSize());
        Assert.assertEquals((long)4200L, (long)ccd.getPhysicalAreaSerialSize());
    }

    @Test
    public void testITLDimensions() {
        CCDType ccd = CCDType.ITL;
        Assert.assertEquals((long)2000L, (long)ccd.getSegmentParallelActiveSize());
        Assert.assertEquals((long)509L, (long)ccd.getSegmentSerialActiveSize());
        Assert.assertEquals((long)4000L, (long)ccd.getActiveAreaParallelSize());
        Assert.assertEquals((long)4072L, (long)ccd.getActiveAreaSerialSize());
        Assert.assertEquals((long)4198L, (long)ccd.getPhysicalAreaParallelSize());
        Assert.assertEquals((long)4198L, (long)ccd.getPhysicalAreaSerialSize());
    }

    public void testE2VInterface(CCDInterface ccd, int cp, int cs, int rp, int rs, boolean testRaftValues) {
        ++e2vTests;
        int seg = 0;
        for (SegmentInterface segment : ccd.getSegments()) {
            int p = segment.getParallelPosition();
            int s = segment.getSerialPosition();
            Map header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)segment);
            TestCase.assertEquals((Object)"[1:4096,1:4004]", header.get("DETSIZE"));
            TestCase.assertEquals((Object)("Segment" + p + s), header.get("EXTNAME"));
            TestCase.assertEquals((Object)this.e2vDETSEC[seg], header.get("DETSEC"));
            TestCase.assertEquals((Object)"[11:522,1:2002]", header.get("DATASEC"));
            TestCase.assertEquals((Object)this.e2vDTV1[seg], header.get("DTV1"));
            TestCase.assertEquals((Object)this.e2vDTV2[seg], header.get("DTV2"));
            TestCase.assertEquals((Object)this.e2vDTM1_1[seg], header.get("DTM1_1"));
            TestCase.assertEquals((Object)this.e2vDTM2_2[seg], header.get("DTM2_2"));
            TestCase.assertEquals((Object)this.e2vCRVAL1A[seg], header.get("CRVAL1A"));
            TestCase.assertEquals((Object)this.e2vCRVAL2A[seg], header.get("CRVAL2A"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC1_2A"));
            TestCase.assertEquals((Object)this.e2vPC2_1A[seg], header.get("PC2_1A"));
            TestCase.assertEquals((Object)this.e2vCRVAL1C[seg], header.get("CRVAL1C"));
            TestCase.assertEquals((Object)this.e2vCRVAL2C[seg], header.get("CRVAL2C"));
            TestCase.assertEquals((Object)this.e2vPC1_2C[seg], header.get("PC1_2C"));
            TestCase.assertEquals((Object)this.e2vPC2_1C[seg], header.get("PC2_1C"));
            if (testRaftValues) {
                TestCase.assertEquals((Object)this.e2vCRVAL1R[cp][seg], header.get("CRVAL1R"));
                TestCase.assertEquals((Object)this.e2vCRVAL2R[cs][seg], header.get("CRVAL2R"));
                TestCase.assertEquals((Object)(this.e2vCRVAL1F[cp][seg] + (double)(rp * CCDType.E2V.getRaftx())), header.get("CRVAL1F"));
                TestCase.assertEquals((Object)(this.e2vCRVAL2F[cs][seg] + (double)(rs * CCDType.E2V.getRafty())), header.get("CRVAL2F"));
                TestCase.assertEquals((Object)this.e2vCRVAL2R[cs][seg], header.get("CRVAL1Q"));
                TestCase.assertEquals((Object)this.e2vCRVAL1R[cp][seg], header.get("CRVAL2Q"));
            }
            TestCase.assertEquals((Object)this.e2vPC1_2R[seg], header.get("PC1_2R"));
            TestCase.assertEquals((Object)this.e2vPC2_1R[seg], header.get("PC2_1R"));
            TestCase.assertEquals((Object)this.e2vPC1_2F[seg], header.get("PC1_2F"));
            TestCase.assertEquals((Object)this.e2vPC2_1F[seg], header.get("PC2_1F"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC1_1B"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC2_2B"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC1_1Q"));
            TestCase.assertEquals((Object)this.e2vPC1_2A[seg], header.get("PC2_2Q"));
            TestCase.assertEquals((Object)this.e2vCRVAL2C[seg], header.get("CRVAL1B"));
            TestCase.assertEquals((Object)this.e2vCRVAL1C[seg], header.get("CRVAL2B"));
            this.testGeneralSegment(header, seg + 1);
            ++seg;
        }
    }

    @Test
    public void testITLNew() {
        FocalPlane fp = new FocalPlane();
        CCDType type = CCDType.ITL;
        Raft raft00 = Raft.createRaft((String)"R00", (CCDType)type);
        fp.addChildGeometry((Geometry)raft00, 0, 0);
        Raft raft43 = Raft.createRaft((String)"R43", (CCDType)type);
        fp.addChildGeometry((Geometry)raft43, 4, 3);
        for (Raft raft : fp.getChildrenList()) {
            for (int p = 0; p < raft.getParallelChildrenCount(); ++p) {
                Reb reb = (Reb)raft.getChild(p, 0);
                for (int s = 0; s < reb.getSerialChildrenCount(); ++s) {
                    this.testITLInterface((CCDInterface)reb.getChild(0, s), p, s, raft.getParallelPosition(), raft.getSerialPosition(), true);
                }
            }
        }
    }

    @Test
    public void testITL() {
        CCDType type = CCDType.ITL;
        CCDGeometry geometry = type.getGeometry();
        this.testITLInterface((CCDInterface)geometry, 0, 0, 0, 0, false);
    }

    public void testITLInterface(CCDInterface ccd, int cp, int cs, int rp, int rs, boolean testRaftValues) {
        ++itlTests;
        int seg = 0;
        for (SegmentInterface segment : ccd.getSegments()) {
            int p = segment.getParallelPosition();
            int s = segment.getSerialPosition();
            Map header = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)segment);
            TestCase.assertEquals((Object)"[1:4072,1:4000]", header.get("DETSIZE"));
            TestCase.assertEquals((Object)("Segment" + p + s), header.get("EXTNAME"));
            TestCase.assertEquals((Object)this.itlDETSEC[seg], header.get("DETSEC"));
            TestCase.assertEquals((Object)"[4:512,1:2000]", header.get("DATASEC"));
            TestCase.assertEquals((Object)this.itlDTV2[seg], header.get("DTV2"));
            TestCase.assertEquals((Object)this.itlDTM1_1[seg], header.get("DTM1_1"));
            TestCase.assertEquals((Object)this.itlDTM2_2[seg], header.get("DTM2_2"));
            TestCase.assertEquals((Object)this.itlCRVAL1A[seg], header.get("CRVAL1A"));
            TestCase.assertEquals((Object)this.itlCRVAL2A[seg], header.get("CRVAL2A"));
            TestCase.assertEquals((Object)this.itlPC1_2A[seg], header.get("PC1_2A"));
            TestCase.assertEquals((Object)this.itlPC2_1A[seg], header.get("PC2_1A"));
            TestCase.assertEquals((Object)this.itlCRVAL1C[seg], header.get("CRVAL1C"));
            TestCase.assertEquals((Object)this.itlCRVAL2C[seg], header.get("CRVAL2C"));
            TestCase.assertEquals((Object)this.itlPC1_2C[seg], header.get("PC1_2C"));
            TestCase.assertEquals((Object)this.itlPC2_1C[seg], header.get("PC2_1C"));
            if (testRaftValues) {
                TestCase.assertEquals((Object)this.itlCRVAL1R[cp][seg], header.get("CRVAL1R"));
                TestCase.assertEquals((Object)this.itlCRVAL2R[cs][seg], header.get("CRVAL2R"));
                TestCase.assertEquals((Object)(this.itlCRVAL1F[cp][seg] + (double)(rp * CCDType.ITL.getRaftx())), header.get("CRVAL1F"));
                TestCase.assertEquals((Object)(this.itlCRVAL2F[cs][seg] + (double)(rs * CCDType.ITL.getRafty())), header.get("CRVAL2F"));
                TestCase.assertEquals((Object)this.itlCRVAL2R[cs][seg], header.get("CRVAL1Q"));
                TestCase.assertEquals((Object)this.itlCRVAL1R[cp][seg], header.get("CRVAL2Q"));
            }
            TestCase.assertEquals((Object)this.itlPC1_2R[seg], header.get("PC1_2R"));
            TestCase.assertEquals((Object)this.itlPC2_1R[seg], header.get("PC2_1R"));
            TestCase.assertEquals((Object)this.itlPC1_2F[seg], header.get("PC1_2F"));
            TestCase.assertEquals((Object)this.itlPC2_1F[seg], header.get("PC2_1F"));
            TestCase.assertEquals((Object)this.itlPC1_2A[seg], header.get("PC2_2B"));
            TestCase.assertEquals((Object)this.itlPC2_1A[seg], header.get("PC1_1B"));
            TestCase.assertEquals((Object)this.itlPC1_2A[seg], header.get("PC2_2Q"));
            TestCase.assertEquals((Object)this.itlPC2_1A[seg], header.get("PC1_1Q"));
            TestCase.assertEquals((Object)this.itlCRVAL2C[seg], header.get("CRVAL1B"));
            TestCase.assertEquals((Object)this.itlCRVAL1C[seg], header.get("CRVAL2B"));
            this.testGeneralSegment(header, seg + 1);
            ++seg;
        }
    }

    private void testGeneralSegment(Map<String, Object> header, int id) {
        TestCase.assertEquals((Object)id, (Object)header.get("CHANNEL"));
        TestCase.assertEquals((Object)"1 1", (Object)header.get("CCDSUM"));
    }

    @Test
    public void testE2VGlobalTranform() {
        CCDType type = CCDType.E2V;
        CCDGeometry ccd = type.getGeometry();
        this.testGlobalTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testGlobalTransform((CCDInterface)ccd1);
    }

    @Test
    public void testITLGlobalTranform() {
        CCDType type = CCDType.ITL;
        CCDGeometry ccd = type.getGeometry();
        this.testGlobalTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testGlobalTransform((CCDInterface)ccd1);
    }

    @Test
    public void testE2VActiveTranform() {
        CCDType type = CCDType.E2V;
        CCDGeometry ccd = type.getGeometry();
        this.testActiveTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testActiveTransform((CCDInterface)ccd1);
    }

    @Test
    public void testITLActiveTranform() {
        CCDType type = CCDType.ITL;
        CCDGeometry ccd = type.getGeometry();
        this.testActiveTransform((CCDInterface)ccd);
        CCD ccd1 = CCD.createCCD((String)"sensor00", (CCDType)type);
        this.testActiveTransform((CCDInterface)ccd1);
    }

    private void testActiveTransform(CCDInterface ccd) {
        CCDTransform local1 = CCDTransform.getActiveTransform((CCDInterface)ccd);
        CCDTransform local2 = CCDTransform.getActiveTransform((CCDInterface)ccd);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = r.nextInt(ccd.getActiveSerialSize());
            int y = r.nextInt(ccd.getActiveParallelSize());
            local1.setXY(x, y);
            local2.setSegmentSerialParallel(local1.getSegment(), local1.getSerial(), local1.getParallel());
            this.testEqual(local1, local2);
        }
    }

    private void testGlobalTransform(CCDInterface ccd) {
        CCDTransform global1 = CCDTransform.getGlobalTransform((CCDInterface)ccd);
        CCDTransform global2 = CCDTransform.getGlobalTransform((CCDInterface)ccd);
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            int x = r.nextInt(ccd.getTotalSerialSize());
            int y = r.nextInt(ccd.getTotalParallelSize());
            global1.setXY(x, y);
            global2.setSegmentSerialParallel(global1.getSegment(), global1.getSerial(), global1.getParallel());
            this.testEqual(global1, global2);
        }
    }

    private void testEqual(CCDTransform global1, CCDTransform global2) {
        TestCase.assertEquals((int)global1.getX(), (int)global2.getX());
        TestCase.assertEquals((int)global1.getY(), (int)global2.getY());
        TestCase.assertEquals((int)global1.getGlobalX(), (int)global2.getGlobalX());
        TestCase.assertEquals((int)global1.getGlobalY(), (int)global2.getGlobalY());
        TestCase.assertEquals((Object)global1.getSegment(), (Object)global2.getSegment());
        TestCase.assertEquals((int)global1.getSerial(), (int)global2.getSerial());
        TestCase.assertEquals((int)global1.getParallel(), (int)global2.getParallel());
        TestCase.assertEquals((Object)global1.getPixelType(), (Object)global2.getPixelType());
    }

    @Test
    public void testE2V_CCDdesignators() {
        CCDType type = CCDType.E2V;
        TestCase.assertEquals((int)type.getDimv(), (int)2002);
        TestCase.assertEquals((int)type.getDimh(), (int)512);
        TestCase.assertEquals((int)type.getCCDax(), (int)4004);
        TestCase.assertEquals((int)type.getCCDay(), (int)4096);
        TestCase.assertEquals((int)type.getCCDpx(), (int)4197);
        TestCase.assertEquals((int)type.getCCDpy(), (int)4200);
        TestCase.assertEquals((int)type.getGap_inx(), (int)28);
        TestCase.assertEquals((int)type.getGap_iny(), (int)25);
        TestCase.assertEquals((Object)type.getGap_outx(), (Object)26.5);
        TestCase.assertEquals((Object)type.getGap_outy(), (Object)25.0);
        TestCase.assertEquals((int)type.getRaftx(), (int)12700);
        TestCase.assertEquals((int)type.getRafty(), (int)12700);
    }

    @Test
    public void testITL_CCDdesignators() {
        CCDType type = CCDType.ITL;
        TestCase.assertEquals((int)type.getDimv(), (int)2000);
        TestCase.assertEquals((int)type.getDimh(), (int)509);
        TestCase.assertEquals((int)type.getCCDax(), (int)4000);
        TestCase.assertEquals((int)type.getCCDay(), (int)4072);
        TestCase.assertEquals((int)type.getCCDpx(), (int)4198);
        TestCase.assertEquals((int)type.getCCDpy(), (int)4198);
        TestCase.assertEquals((int)type.getGap_inx(), (int)27);
        TestCase.assertEquals((int)type.getGap_iny(), (int)27);
        TestCase.assertEquals((Object)type.getGap_outx(), (Object)26.0);
        TestCase.assertEquals((Object)type.getGap_outx(), (Object)26.0);
        TestCase.assertEquals((int)type.getRaftx(), (int)12700);
        TestCase.assertEquals((int)type.getRafty(), (int)12700);
    }
}

