/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rafts.demo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.ccd.CCDInterface;
import org.lsst.ccs.utilities.ccd.SegmentInterface;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class RawImageConverter {
    private static final Logger logger = Logger.getLogger(RawImageConverter.class.getName());
    private final CCDInterface geom;
    private final DefaultImageSet imageSet;
    private final BufferedImage rawImage;
    private static final int BUFFER_SIZE = 1000000;

    RawImageConverter(BufferedImage rawImage, CCDInterface geom, int raftOffsetX, int raftOffsetY) {
        this.rawImage = rawImage;
        this.geom = geom;
        HashMap metaData = new HashMap();
        metaData.putAll(FitsHeaderUtilities.getCCDPrimaryHeaders((CCDInterface)geom));
        this.imageSet = new DefaultImageSet(metaData);
        long start = System.currentTimeMillis();
        for (SegmentInterface segment : geom.getSegments()) {
            MetaDataSet metaDataSet = new MetaDataSet();
            Map imageMetaData = FitsHeaderUtilities.getSegmentHeaders((SegmentInterface)segment);
            metaDataSet.addMetaData("channel", imageMetaData);
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("WCSNAMEr", "RAFT");
            extra.put("CTYPE1r", "RAFT_X");
            extra.put("CTYPE2r", "RAFT_Y");
            extra.put("CUNIT1r", "pixel");
            extra.put("CUNIT2r", "pixel");
            extra.put("PC1_1r", imageMetaData.get("PC1_1"));
            extra.put("PC1_2r", 0.0);
            extra.put("PC2_1r", 0.0);
            extra.put("PC2_2r", imageMetaData.get("PC2_2"));
            extra.put("CRPIX1r", ((Number)imageMetaData.get("CRPIX1")).intValue() + raftOffsetX);
            extra.put("CRPIX2r", ((Number)imageMetaData.get("CRPIX2")).intValue() + raftOffsetY);
            metaDataSet.addMetaData("raft-wcs", extra);
            this.imageSet.addImage(geom.getType().getSegmentTotalSerialSize(), geom.getType().getSegmentTotalParallelSize(), (Map)metaDataSet);
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.FINE, "Analyzed image in {0}ms", stop - start);
    }

    ImageSet getImageSet() {
        return this.imageSet;
    }

    void pushDataToFile(FitsFileWriter writer) throws IOException {
        long start = System.currentTimeMillis();
        ByteBuffer dest = ByteBuffer.allocate(1000000);
        dest.order(ByteOrder.BIG_ENDIAN);
        for (SegmentInterface segment : this.geom.getSegments()) {
            BufferedImage sImage = new BufferedImage(this.geom.getTotalSerialSize(), this.geom.getTotalParallelSize(), 11);
            Graphics2D g2 = sImage.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, sImage.getWidth(), sImage.getHeight());
            BufferedImage aImage = this.rawImage.getSubimage(segment.getSerialPosition() * segment.getSegmentSerialActiveSize(), (1 - segment.getParallelPosition()) * segment.getSegmentParallelActiveSize(), segment.getSegmentSerialActiveSize(), segment.getSegmentParallelActiveSize());
            int x = segment.getSegmentSerialPrescanSize();
            int y = 0;
            int h = segment.getSegmentParallelActiveSize();
            int w = segment.getSegmentSerialActiveSize();
            g2.translate(x, y);
            if (!segment.isReadoutLeft()) {
                g2.translate(w, 0);
                g2.scale(-1.0, 1.0);
            }
            if (segment.isReadoutDown()) {
                g2.translate(0, h);
                g2.scale(1.0, -1.0);
            }
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.drawImage(aImage, 0, 0, w, h, null);
            g2.dispose();
            WritableRaster data = sImage.getRaster();
            for (int col = 0; col < segment.getSegmentTotalParallelSize(); ++col) {
                for (int row = 0; row < segment.getSegmentTotalSerialSize(); ++row) {
                    int val = data.getSample(row, col, 0);
                    dest.putInt(val);
                    if (dest.hasRemaining()) continue;
                    dest.flip();
                    writer.write(segment.getChannel() - 1, dest);
                    dest.clear();
                }
            }
            dest.flip();
            writer.write(segment.getChannel() - 1, dest);
            dest.clear();
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.INFO, "Wrote image in {0}ms", stop - start);
    }
}

